/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.config.GcApiConfig;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcTrackable;
import io.ultreia.gc.service.GcAuthService;
import io.ultreia.gc.service.GcServiceContext;
import io.ultreia.gc.service.GcServiceSupport;
import io.ultreia.gc.session.GcSession;
import java.lang.reflect.Type;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ArgumentsParserException;

public class GcTrackableService
extends GcServiceSupport {
    private static final Log log = LogFactory.getLog(GcTrackableService.class);

    @Override
    public Set<GcTrackable> getTrackables() {
        GcSession gcSession = this.getGcSession();
        GcRequest request = gcSession.forGet("https://www.geocaching.com/api/proxy/trackables?inCollection=false").addAuthToken().build();
        GcResponse build = gcSession.executeRequest(request);
        Type type = new TypeToken<Set<GcTrackable>>(){}.getType();
        return (Set)build.getResponseAsJson(type);
    }

    public static void main(String[] args) throws ArgumentsParserException {
        GcApiConfig config = new GcApiConfig();
        config.get().parse(args);
        String sessionId = new GcAuthService().login(config.getLogin(), config.getPassword());
        log.info((Object)("SessionId: " + sessionId));
        GcServiceContext serviceContext = GcServiceContext.create(sessionId);
        GcTrackableService service = new GcTrackableService();
        service.setServiceContext(serviceContext);
        Set<GcTrackable> trackables = service.getTrackables();
        log.info((Object)("trackables: " + trackables.size()));
    }
}

