/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcRequestBuilder;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcTrackable;
import io.ultreia.gc.service.GcServiceContext;
import io.ultreia.gc.session.GcSession;
import io.ultreia.gc.session.GcSessionsStore;
import java.util.Optional;
import java.util.Set;

public abstract class GcServiceSupport {
    GcServiceContext serviceContext;

    public void setServiceContext(GcServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    GcSession getGcSession() {
        Optional<String> optionalAuthId = this.serviceContext.getAuthId();
        if (!optionalAuthId.isPresent()) {
            throw new RuntimeException("No authId found in service context");
        }
        Optional<GcSession> session = GcSessionsStore.get().getSession(optionalAuthId.get());
        if (!session.isPresent()) {
            throw new RuntimeException("session not found for authId: " + optionalAuthId.get());
        }
        return session.get();
    }

    public Set<GcTrackable> getTrackables() {
        return this.getGcSession().getTrackables();
    }

    public String getUsername() {
        return this.getGcSession().getUsername();
    }

    public GcRequestBuilder forGet(String baseUrl) {
        return this.getGcSession().forGet(baseUrl);
    }

    public GcRequestBuilder forPost(String baseUrl) {
        return this.getGcSession().forPost(baseUrl);
    }

    public GcRequestBuilder forDelete(String baseUrl) {
        return this.getGcSession().forDelete(baseUrl);
    }

    public GcRequestBuilder forPatch(String baseUrl) {
        return this.getGcSession().forPatch(baseUrl);
    }

    public GcResponse executeRequest(GcRequest request) {
        return this.getGcSession().executeRequest(request);
    }

    public GcResponse executeRequest(GcRequest request, int expectedStatusCode) {
        GcResponse response = this.getGcSession().executeRequest(request);
        this.checkStatusCode(response, expectedStatusCode);
        return response;
    }

    void checkStatusCode(GcResponse response, int expectedStatusCode) {
        if (response.getStatusCode() != expectedStatusCode) {
            throw new IllegalStateException(String.format("Should have a %d status code, but got %d", expectedStatusCode, response.getStatusCode()));
        }
    }
}

