/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcArcheoLog;
import io.ultreia.gc.model.GcLog;
import io.ultreia.gc.service.GcArcheoLogsComputationProgressMonitor;
import io.ultreia.gc.service.GcArcheoLogsComputationResult;
import io.ultreia.gc.service.GcServiceSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class GcLogService
extends GcServiceSupport {
    private static final Log log = LogFactory.getLog(GcLogService.class);

    public GcLog getMyLogFromCacheGuid(String guid) {
        GcRequest request = this.forGet("https://www.geocaching.com/seek/cache_details.aspx").addParameter("guid", guid).build();
        GcResponse build = this.executeRequest(request);
        Document doc = build.getResponseAsHtml();
        String userToken = null;
        for (Element element : doc.select("script[type='text/javascript']")) {
            String text = element.data();
            if (!text.contains("userToken = '")) continue;
            int i = text.indexOf("userToken =");
            int start = text.indexOf("'", i) + 1;
            int end = text.indexOf("'", start);
            userToken = text.substring(start, end);
            log.info((Object)("User token: " + userToken));
        }
        Objects.requireNonNull(userToken);
        Iterator<GcLog> gcLogIterator = this.newGcLogIterator(userToken, 20);
        GcLog myLog = null;
        while (gcLogIterator.hasNext()) {
            GcLog gcLog = gcLogIterator.next();
            if (!gcLog.isFoundByUser(this.getUsername())) continue;
            myLog = gcLog;
            break;
        }
        return myLog;
    }

    public Optional<GcArcheoLog> getMyArcheoLogFromGcName(String gcName, String username) {
        log.info((Object)("Seek archeo logs for cache: " + gcName));
        GcRequest request = this.forGet("https://coord.info/" + gcName).build();
        GcResponse build = this.executeRequest(request);
        Document doc = build.getResponseAsHtml();
        String userToken = null;
        for (Element element : doc.select("script[type='text/javascript']")) {
            String text = element.data();
            if (!text.contains("userToken = '")) continue;
            int i = text.indexOf("userToken =");
            int start = text.indexOf("'", i) + 1;
            int end = text.indexOf("'", start);
            userToken = text.substring(start, end);
            log.debug((Object)("User token: " + userToken));
            break;
        }
        Objects.requireNonNull(userToken);
        Iterator<GcLog> gcLogIterator = this.newGcLogIterator(userToken, 20);
        GcLog myLog = null;
        while (gcLogIterator.hasNext()) {
            GcLog gcLog = gcLogIterator.next();
            if (!gcLog.isFoundByUser(username)) continue;
            myLog = gcLog;
            break;
        }
        if (myLog == null) {
            return Optional.empty();
        }
        Objects.requireNonNull(myLog);
        GcLog previousLog = null;
        while (gcLogIterator.hasNext()) {
            GcLog gcLog = gcLogIterator.next();
            if (!gcLog.isFoundIt()) continue;
            previousLog = gcLog;
            break;
        }
        return Optional.of(new GcArcheoLog(gcName, "" + myLog.getCacheId(), myLog, previousLog));
    }

    public GcArcheoLogsComputationResult computeArcheoCaches(String username, Collection<String> gcNames, List<GcArcheoLog> cache, File output, GcArcheoLogsComputationProgressMonitor progressMonitor) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        int gcNamesSize = gcNames.size();
        LinkedHashSet<GcArcheoLog> logs = new LinkedHashSet<GcArcheoLog>();
        logs.addAll(cache);
        progressMonitor.setValue(cache.size());
        GcArcheoLogsComputationResult result = new GcArcheoLogsComputationResult();
        TreeMap existingCacheMapping = new TreeMap();
        cache.forEach(archeoLog -> {
            existingCacheMapping.put(archeoLog.getGcName(), archeoLog);
            archeoLog.computeType();
            this.addResult(result, (GcArcheoLog)archeoLog, progressMonitor);
        });
        this.storeArcheoLogs(output, gson, logs);
        ((Stream)gcNames.stream().filter(gcName -> !existingCacheMapping.containsKey(gcName)).parallel()).forEach(gcName -> {
            Optional<GcArcheoLog> optionalArcheoLog = this.getMyArcheoLogFromGcName((String)gcName, username);
            if (!optionalArcheoLog.isPresent()) {
                log.warn((Object)("Could not find my found it on cache: " + gcName));
                result.addBadGcName((String)gcName);
                progressMonitor.increment(String.format("[Total points: %d] - Could not find my found it on cache: %s (%d/%d)", result.getTotalPoints(), gcName, result.getBadGcNames().size() + logs.size(), gcNamesSize));
                return;
            }
            GcArcheoLog archeoLog = optionalArcheoLog.get();
            logs.add(archeoLog);
            this.addResult(result, archeoLog, progressMonitor);
            progressMonitor.increment(String.format("[Total points: %d] - Done for cache: %s (%d/%d)", result.getTotalPoints(), gcName, result.getBadGcNames().size() + logs.size(), gcNamesSize));
            GcLogService gcLogService = this;
            synchronized (gcLogService) {
                logs.add(archeoLog);
                if (logs.size() % 20 == 0) {
                    log.info((Object)("Store " + logs.size() + " archeo-log(s) to " + output));
                    this.storeArcheoLogs(output, gson, logs);
                }
            }
        });
        this.storeArcheoLogs(output, gson, logs);
        return result;
    }

    private void addResult(GcArcheoLogsComputationResult result, GcArcheoLog archeoLog, GcArcheoLogsComputationProgressMonitor progressMonitor) {
        archeoLog.getMyLog().setLogText(null);
        archeoLog.getPreviousLog().ifPresent(l -> l.setLogText(null));
        if (result.addResult(archeoLog)) {
            progressMonitor.onPointsAdded(new GcArcheoLogsComputationProgressMonitor.GcArcheoLogEvent(result, archeoLog, result.getTotalPoints()));
        }
    }

    private void storeArcheoLogs(File output, Gson gson, Set<GcArcheoLog> logs) {
        try {
            Files.write(output.toPath(), gson.toJson(logs).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HashMap toJson(String content) {
        return (HashMap)new GsonBuilder().setPrettyPrinting().create().fromJson(content, HashMap.class);
    }

    private Iterator<GcLog> newGcLogIterator(final String userToken, final int pageSize) {
        return new Iterator<GcLog>(){
            int pageIndex = 0;
            int pageTotal = 1;
            Iterator<Map> buffer;

            @Override
            public boolean hasNext() {
                if (this.getBuffer(true).hasNext()) {
                    return true;
                }
                if (this.pageIndex == this.pageTotal) {
                    return false;
                }
                this.buffer = null;
                return this.getBuffer(false).hasNext();
            }

            @Override
            public GcLog next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map next = this.buffer.next();
                return GcLog.fromMap(next);
            }

            Iterator<Map> getBuffer(boolean computePageTotal) {
                if (this.buffer == null) {
                    ++this.pageIndex;
                    GcRequest request = GcLogService.this.forGet("https://www.geocaching.com/seek/geocache.logbook").addParameter("tkn", userToken).addParameter("idx", this.pageIndex + "").addParameter("num", pageSize + "").build();
                    GcResponse response = GcLogService.this.executeRequest(request);
                    HashMap hashMap = GcLogService.this.toJson(response.getResponseAsString());
                    if (computePageTotal) {
                        this.pageTotal = (int)((Double)((Map)hashMap.get("pageInfo")).get("totalRows") / (double)pageSize) + 1;
                    }
                    List data = (List)hashMap.get("data");
                    this.buffer = data.iterator();
                }
                return this.buffer;
            }
        };
    }

    public List<GcArcheoLog> loadArcheoCaches(File cacheFile) throws IOException {
        Gson gson = new GsonBuilder().create();
        BufferedReader reader = Files.newBufferedReader(cacheFile.toPath());
        return (List)gson.fromJson((Reader)reader, new TypeToken<List<GcArcheoLog>>(){}.getType());
    }
}

