/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.model.GcLog;
import io.ultreia.gc.service.GcServiceSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class GcCacheService
extends GcServiceSupport {
    private static final Log log = LogFactory.getLog(GcCacheService.class);

    public void storeCaches(List<GcCache> caches, File output) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(output.toPath(), new OpenOption[0]);){
            gson.toJson(caches, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GcCache> loadCaches(File output) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedReader reader = Files.newBufferedReader(output.toPath());){
            Type type = new TypeToken<List<GcCache>>(){}.getType();
            List list = (List)gson.fromJson((Reader)reader, type);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void getCacheFromGuid(String guid) {
        GcRequest request = this.forGet("https://www.geocaching.com/seek/cache_details.aspx").addParameter("guid", guid).build();
        GcResponse build = this.executeRequest(request);
        Document doc = build.getResponseAsHtml();
        LinkedList<GcLog> allLogs = new LinkedList<GcLog>();
        for (Element element : doc.select("script[type='text/javascript']")) {
            String text = element.data();
            if (!text.contains("userToken = '")) continue;
            int i = text.indexOf("userToken =");
            int start = text.indexOf("'", i) + 1;
            int end = text.indexOf("'", start);
            String userToken = text.substring(start, end);
            log.info((Object)("User token: " + userToken));
            i = text.indexOf("initalLogs = ");
            start = text.indexOf("{", i);
            end = text.indexOf("};", start) + 1;
            String logs = text.substring(start, end);
            HashMap hashMap = (HashMap)new GsonBuilder().setPrettyPrinting().create().fromJson(logs, HashMap.class);
            List data = (List)hashMap.get("data");
            for (Object datum : data) {
                GcLog gcLog = GcLog.fromMap((Map)datum);
                allLogs.add(gcLog);
            }
            log.info((Object)("logs: " + hashMap));
        }
        String uploadUrl = doc.select("a[title='Upload Image']").attr("href");
        log.info((Object)("Upload image url: " + uploadUrl));
    }

    public GcCache getCacheRefFromGcName(String gcName) {
        GcRequest request = this.forGet("https://www.geocaching.com/api/proxy/web/v1/geocache/" + gcName).addAuthToken().build();
        GcResponse response = this.executeRequest(request);
        Document responseAsHtml = response.getResponseAsHtml();
        return GcCache.fromXml(responseAsHtml);
    }
}

