/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import io.ultreia.gc.model.GcArcheoLog;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GcArcheoLogsComputationResult {
    private static final Log log = LogFactory.getLog(GcArcheoLogsComputationResult.class);
    private final TreeMap<Integer, List<GcArcheoLog>> data = new TreeMap();
    private final Set<String> badGcNames;
    private int totalPoints;

    GcArcheoLogsComputationResult() {
        this.data.put(5, new LinkedList());
        this.data.put(10, new LinkedList());
        this.data.put(15, new LinkedList());
        this.data.put(20, new LinkedList());
        this.data.put(30, new LinkedList());
        this.badGcNames = new LinkedHashSet<String>();
    }

    void addBadGcName(String gcName) {
        this.badGcNames.add(gcName);
    }

    public Set<String> getBadGcNames() {
        return this.badGcNames;
    }

    boolean addResult(GcArcheoLog archeoLog) {
        int score = archeoLog.getScore();
        if (score > 0) {
            this.data.get(score).add(archeoLog);
            this.totalPoints += score;
            log.info((Object)String.format("[Total: %d] Found a %s points cache: %s", this.totalPoints, score, archeoLog.getGcName()));
            return true;
        }
        return false;
    }

    public int getTotalPoints() {
        return this.totalPoints;
    }
}

