/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import io.ultreia.gc.config.GcApiConfig;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcRequestBuilder;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcCacheImage;
import io.ultreia.gc.model.GcFieldNote;
import io.ultreia.gc.model.GcLogDraft;
import io.ultreia.gc.model.GcTrackable;
import io.ultreia.gc.service.GcAuthService;
import io.ultreia.gc.service.GcServiceContext;
import io.ultreia.gc.service.GcServiceSupport;
import io.ultreia.gc.service.ProgressMonitor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.nuiton.config.ArgumentsParserException;

public class FieldNotesService
extends GcServiceSupport {
    private static final Log log = LogFactory.getLog(FieldNotesService.class);
    private static final String URL_GET_FIELD_NOTES = "https://www.geocaching.com/my/fieldnotes.aspx";
    private static final String URL_GET_FIELD_NOTE_FORM = "https://www.geocaching.com/my/%s";
    private static final String URL_SEND_LOG_IMAGE = "https://www.geocaching.com/api/proxy/web/v1/LogDrafts/images";
    private static final String URL_SEND_LOG = "https://www.geocaching.com/api/proxy/web/v1/Geocache/%s/GeocacheLog";
    private static final String URL_ATTACH_IMAGE_TO_LOG = "https://www.geocaching.com/api/proxy/web/v1/LogDrafts/images/%s?geocacheLogReferenceCode=%s";
    private static final String URL_DELETE_LOG_DRAFT = "https://www.geocaching.com/api/proxy/web/v1/LogDrafts/%s";
    private static final String URL_GET_LOG_DRAFT = "https://www.geocaching.com/api/proxy/web/v1/LogDrafts/%s";
    private MustacheFactory mustacheFactory;

    public List<GcFieldNote> loadFieldNotes() {
        GcRequest request = this.forGet(URL_GET_FIELD_NOTES).build();
        GcResponse build = this.executeRequest(request, 200);
        Document doc = build.getResponseAsHtml();
        Elements trs = doc.select("table[class=Table] > tbody > tr");
        LinkedList<GcFieldNote> fieldNotes = new LinkedList<GcFieldNote>();
        for (Element tr : trs) {
            Elements select = tr.select("td > a[href^=https://www]");
            String name = select.text();
            String url = select.attr("href");
            String date = tr.child(2).text();
            String logType = tr.child(3).text();
            String composeUrl = tr.child(4).select(" a[href^=fieldnotes.aspx?composeLog=]").first().attr("href");
            fieldNotes.add(new GcFieldNote(name, url, composeUrl, date, logType));
        }
        log.info((Object)("Found " + fieldNotes.size() + " field note(s)."));
        fieldNotes.forEach(c -> log.debug((Object)("Cache " + c + " - " + c.getComposeUrl())));
        return fieldNotes;
    }

    public void logFieldNote(GcFieldNote fieldNote, String logText, boolean autoVisitTrackables, ProgressMonitor progressBarModel) {
        GcResponse response;
        GcRequest request;
        progressBarModel.increment("Prepare log for cache: " + fieldNote.getName());
        GcRequest request2 = this.forGet(String.format(URL_GET_FIELD_NOTE_FORM, fieldNote.getComposeUrl())).build();
        GcResponse response2 = this.executeRequest(request2, 200);
        Document doc = response2.getResponseAsHtml();
        String logId = doc.select("meta[name='og:url']").attr("content").split("=")[1];
        String gcName = doc.select("h1[class='muted'] > a").attr("href").split("/")[2];
        String date = doc.select("input[id='LogDate']").attr("value");
        String ownerName = doc.select("h1[class='muted'] > a:nth-child(2)").text();
        int cacheCount = Integer.valueOf(doc.select("span[class='cache-count']").text().split(" ")[0].replace(",", ""));
        log.debug((Object)("LogId: " + logId));
        log.debug((Object)("GcName: " + gcName));
        log.debug((Object)("cache count: " + cacheCount));
        log.debug((Object)("the owner: " + ownerName));
        String logType = null;
        String logTypeName = fieldNote.getLogType().toLowerCase();
        for (Element logTypeOption : doc.select("select[class='log-type'] option")) {
            if (!logTypeName.contains(logTypeOption.text().trim().toLowerCase())) continue;
            logType = logTypeOption.attr("value");
            break;
        }
        Objects.requireNonNull(logType);
        String imageId = null;
        if (fieldNote.getImage().isPresent()) {
            progressBarModel.increment("Upload image for cache: " + fieldNote.getName());
            GcLogDraft logDraft = this.getLogDraft(logId);
            GcCacheImage gcCacheImage = fieldNote.getImage().get();
            request = this.forPost(URL_SEND_LOG_IMAGE).addAuthToken().useMultiPartForm().addParameter("guid", logDraft.getGuid()).addParameter("name", gcCacheImage.getContent().getName() + System.nanoTime()).addParameter("qqtotalfilesize", gcCacheImage.getContent().length() + "").addFile("qqfile", gcCacheImage.getContent()).build();
            progressBarModel.increment("Send log for cache: " + fieldNote.getName());
            response = this.executeRequest(request, 201);
            Document responseAsHtml = response.getResponseAsHtml();
            imageId = responseAsHtml.select("guid").text();
        }
        GcRequestBuilder requestBuilder = this.forPost(String.format(URL_SEND_LOG, gcName)).addAuthToken().addHiddenInputs(doc).addParameter("geocache[referenceCode]", gcName).addParameter("logType", logType).addParameter("logDate", date).addParameter("referenceCode", logId).addParameter("logText", this.getLogText(logText, ownerName, cacheCount)).addParameter("addedFavorite", fieldNote.isFavorite());
        if (autoVisitTrackables) {
            for (GcTrackable trackable : this.getTrackables()) {
                requestBuilder.addParameter("trackableActivity[" + trackable.getReferenceCode() + "]", "75");
            }
        }
        progressBarModel.increment("Send log for cache: " + fieldNote.getName());
        request = requestBuilder.build();
        response = this.executeRequest(request, 200);
        String realLogId = response.getResponseAsHtml().select("geocachelog > ReferenceCode").text();
        log.info((Object)("Real log id: " + realLogId));
        Objects.requireNonNull(realLogId);
        if (imageId != null) {
            progressBarModel.increment("Attach image to log for cache: " + fieldNote.getName());
            request = this.forPatch(String.format(URL_ATTACH_IMAGE_TO_LOG, imageId, realLogId)).addAuthToken().build();
            this.executeRequest(request, 200);
        }
        progressBarModel.increment("Delete field note for cache: " + fieldNote.getName());
        request = this.forDelete(String.format("https://www.geocaching.com/api/proxy/web/v1/LogDrafts/%s", logId)).addAuthToken().build();
        this.executeRequest(request, 200);
    }

    private GcLogDraft getLogDraft(String referenceCode) {
        GcRequest request = this.forGet(String.format("https://www.geocaching.com/api/proxy/web/v1/LogDrafts/%s", referenceCode)).addAuthToken().build();
        GcResponse response = this.executeRequest(request, 200);
        Document responseAsHtml = response.getResponseAsHtml();
        return GcLogDraft.fromXml(responseAsHtml);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLogText(String logText, String theOwner, int cacheCount) {
        Mustache mustache = this.getMustacheFactory().compile((Reader)new StringReader(logText), "archeo");
        HashMap<String, Object> mustacheModel = new HashMap<String, Object>();
        mustacheModel.put("found", cacheCount + 1);
        mustacheModel.put("owner", theOwner);
        try (StringWriter logTextWriter = new StringWriter();){
            mustache.execute((Writer)logTextWriter, mustacheModel);
            logTextWriter.flush();
            String string = logTextWriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private MustacheFactory getMustacheFactory() {
        if (this.mustacheFactory == null) {
            this.mustacheFactory = new DefaultMustacheFactory();
        }
        return this.mustacheFactory;
    }

    public static void main(String[] args) throws ArgumentsParserException {
        GcApiConfig config = new GcApiConfig();
        config.get().parse(args);
        String sessionId = new GcAuthService().login(config.getLogin(), config.getPassword());
        log.info((Object)("SessionId: " + sessionId));
        GcServiceContext serviceContext = GcServiceContext.create(sessionId);
        FieldNotesService service2 = new FieldNotesService();
        service2.setServiceContext(serviceContext);
        List<GcFieldNote> gcFieldNotes = service2.loadFieldNotes();
        GcFieldNote gcFieldNote = gcFieldNotes.get(0);
        GcCacheImage image = new GcCacheImage();
        image.setContent(config.getDataDirectory().toPath().resolve("taiste.jpg").toFile());
        image.setTitle("FTF!");
        gcFieldNote.setImage(image);
        service2.logFieldNote(gcFieldNote, "{{found}} - Ftf log \u00e0 zuivre.... MPLC {{owner}}", true, new ProgressMonitor(){

            @Override
            public void increment(String stepMessage) {
            }

            @Override
            public void setValue(int size) {
            }
        });
    }
}

