/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.model;

import io.ultreia.gc.model.GcLog;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class GcArcheoLog {
    private final String gcName;
    private final String cacheUid;
    private final GcLog myLog;
    private final GcLog previousLog;
    private int nbDays;
    private int score;
    private static final Map<Integer, Integer> SCORES_TABLES = new LinkedHashMap<Integer, Integer>();

    public GcArcheoLog(String gcName, String cacheUid, GcLog myLog, GcLog previousLog) {
        this.gcName = gcName;
        this.cacheUid = cacheUid;
        this.myLog = myLog;
        this.previousLog = previousLog;
        this.computeType();
    }

    public void computeType() {
        this.getPreviousLog().ifPresent(pl -> {
            Date myDate = this.myLog.getDate();
            Date previousDate = this.previousLog.getDate();
            this.nbDays = (int)(TimeUnit.DAYS.convert(myDate.getTime(), TimeUnit.MILLISECONDS) - TimeUnit.DAYS.convert(previousDate.getTime(), TimeUnit.MILLISECONDS));
            for (Map.Entry<Integer, Integer> entry : SCORES_TABLES.entrySet()) {
                if (this.nbDays <= entry.getKey()) continue;
                this.score = entry.getValue();
                break;
            }
        });
    }

    public String getGcName() {
        return this.gcName;
    }

    public String getCacheID() {
        return this.cacheUid;
    }

    public GcLog getMyLog() {
        return this.myLog;
    }

    public Optional<GcLog> getPreviousLog() {
        return Optional.ofNullable(this.previousLog);
    }

    public long getNbDays() {
        return this.nbDays;
    }

    public int getScore() {
        return this.score;
    }

    static {
        SCORES_TABLES.put(500, 30);
        SCORES_TABLES.put(365, 20);
        SCORES_TABLES.put(270, 15);
        SCORES_TABLES.put(180, 10);
        SCORES_TABLES.put(90, 5);
    }
}

