/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.http;

import io.ultreia.gc.http.GcRequest;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class GcRequestBuilder {
    private final List<NameValuePair> parameters;
    private final Map<String, String> headers;
    protected final Map<String, File> files;
    private String requestBody;
    private String contentType;
    private String requestMethod;
    private int timeout = 30000;
    private boolean addAuthToken;
    private boolean useMultipartForm;
    private final String baseUrl;
    private final Supplier<String> authTokenSupplier;

    public static GcRequestBuilder forGet(String baseUrl, Supplier<String> authTokenSupplier) {
        return new GcRequestBuilder("GET", baseUrl, authTokenSupplier);
    }

    public static GcRequestBuilder forPost(String baseUrl, Supplier<String> authTokenSupplier) {
        return new GcRequestBuilder("POST", baseUrl, authTokenSupplier);
    }

    public static GcRequestBuilder forPut(String baseUrl, Supplier<String> authTokenSupplier) {
        return new GcRequestBuilder("PUT", baseUrl, authTokenSupplier);
    }

    public static GcRequestBuilder forDelete(String baseUrl, Supplier<String> authTokenSupplier) {
        return new GcRequestBuilder("DELETE", baseUrl, authTokenSupplier);
    }

    public static GcRequestBuilder forPatch(String baseUrl, Supplier<String> authTokenSupplier) {
        return new GcRequestBuilder("PATCH", baseUrl, authTokenSupplier);
    }

    public GcRequest build() {
        if (this.addAuthToken) {
            this.addHeader("Authorization", this.authTokenSupplier.get());
        }
        Objects.requireNonNull(this.baseUrl, "'baseUrl' can't be null");
        Objects.requireNonNull(this.requestMethod, "'requestMethod' was not setted");
        return new GcRequest(this.requestMethod, this.baseUrl, this.contentType, this.requestBody, this.headers, this.parameters, this.files, this.timeout, this.useMultipartForm);
    }

    public GcRequestBuilder addAuthToken() {
        this.addAuthToken = true;
        return this;
    }

    public GcRequestBuilder useMultiPartForm() {
        this.useMultipartForm = true;
        return this;
    }

    public GcRequestBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public GcRequestBuilder setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public GcRequestBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public GcRequestBuilder addHeader(String key, String value) {
        this.checkRequestNotNull(key, value);
        this.headers.put(key, value);
        return this;
    }

    public GcRequestBuilder addParameter(String parameterName, String value) {
        this.checkParameterNotNull(parameterName, value);
        this.parameters.add((NameValuePair)new BasicNameValuePair(parameterName, value));
        return this;
    }

    public GcRequestBuilder addParameter(String parameterName, boolean value) {
        this.checkParameterNotNull(parameterName, value);
        this.parameters.add((NameValuePair)new BasicNameValuePair(parameterName, String.valueOf(value)));
        return this;
    }

    public GcRequestBuilder addFile(String value, File file) {
        this.checkRequestNotNull(value, file);
        this.files.put(value, file);
        return this;
    }

    public GcRequestBuilder addHiddenInputs(Document doc) {
        for (Element element : doc.select("input[type='hidden']")) {
            String value = element.attr("value");
            if (value == null) continue;
            this.addParameter(element.attr("name"), value);
        }
        return this;
    }

    private GcRequestBuilder(String methodName, String baseUrl, Supplier<String> authTokenSupplier) {
        this.authTokenSupplier = authTokenSupplier;
        Objects.requireNonNull(baseUrl);
        this.baseUrl = baseUrl;
        Objects.requireNonNull(methodName);
        this.requestMethod = methodName;
        this.headers = new LinkedHashMap<String, String>();
        this.files = new LinkedHashMap<String, File>();
        this.parameters = new LinkedList<NameValuePair>();
    }

    private void checkParameterNotNull(String parparameterNamemName, Object value) {
        this.checkKeyValueNotNull(parparameterNamemName, value, "Parameter key must be not null", "Parameter value must be not null for paramName : " + parparameterNamemName);
    }

    private void checkRequestNotNull(String key, Object value) {
        this.checkKeyValueNotNull(key, value, "Request key must be not null", "Request value must be not null for key : " + key);
    }

    private void checkKeyValueNotNull(String key, Object value, String keyErrorMessage, String valueErrorMessage) {
        Objects.requireNonNull(key, keyErrorMessage);
        Objects.requireNonNull(value, valueErrorMessage);
    }

    public GcRequestBuilder addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
        return this;
    }
}

