/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.config;

import io.ultreia.gc.config.GcApiConfigOption;
import io.ultreia.gc.config.GcConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.version.Version;

public class GcApiConfig
implements GcConfig {
    private ApplicationConfig applicationConfig;

    public GcApiConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GcApiConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])GcApiConfigOption.values());
    }

    @Override
    public ApplicationConfig get() {
        return this.applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        this.applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public Path getMyFindsGpx() {
        return this.getDataDirectory().toPath().resolve(String.format("myfinds-%s.gpx", this.getLogin()));
    }

    public Path getMyFindsJson() {
        return this.getDataDirectory().toPath().resolve(String.format("myfinds-%s.json", this.getLogin()));
    }

    @Override
    public File getDataDirectory() {
        return this.applicationConfig.getOptionAsFile(GcApiConfigOption.DATA_DIRECTORY.getKey());
    }

    @Override
    public String getConfigFile() {
        return this.applicationConfig.getOption(GcApiConfigOption.CONFIG_FILE.getKey());
    }

    public void setConfigFile(String configFile) {
        this.setOption(GcApiConfigOption.CONFIG_FILE.getKey(), configFile);
    }

    @Override
    public String getBuildDate() {
        return this.applicationConfig.getOption(GcApiConfigOption.BUILD_DATE.getKey());
    }

    public void setBuildDate(String buildDate) {
        this.setOption(GcApiConfigOption.BUILD_DATE.getKey(), buildDate);
    }

    @Override
    public String getBuildNumber() {
        return this.applicationConfig.getOption(GcApiConfigOption.BUILD_NUMBER.getKey());
    }

    public void setBuildNumber(String buildNumber) {
        this.setOption(GcApiConfigOption.BUILD_NUMBER.getKey(), buildNumber);
    }

    @Override
    public Version getBuildVersion() {
        return this.applicationConfig.getOptionAsVersion(GcApiConfigOption.BUILD_VERSION.getKey());
    }

    public void setBuildVersion(Version buildVersion) {
        this.setOption(GcApiConfigOption.BUILD_VERSION.getKey(), buildVersion);
    }

    @Override
    public String getLogin() {
        return this.applicationConfig.getOption(GcApiConfigOption.LOGIN.getKey());
    }

    @Override
    public void setLogin(String login) {
        this.setOption(GcApiConfigOption.LOGIN.getKey(), login);
    }

    @Override
    public String getPassword() {
        return this.applicationConfig.getOption(GcApiConfigOption.PASSWORD.getKey());
    }

    @Override
    public void setPassword(String password) {
        this.setOption(GcApiConfigOption.PASSWORD.getKey(), password);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", this.get().getConfigFileName()));
        for (GcApiConfigOption option : this.orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), this.get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<GcApiConfigOption> orderedByKey() {
        List<GcApiConfigOption> values = Arrays.asList(GcApiConfigOption.values());
        Collections.sort(values, new Comparator<GcApiConfigOption>(){

            @Override
            public int compare(GcApiConfigOption o1, GcApiConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }
}

