/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.challenge;

import io.ultreia.gc.config.GcApiConfig;
import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.service.GcCacheService;
import io.ultreia.gc.service.GpxService;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ArgumentsParserException;

public class Lavoir90Challenge {
    private static final Log log = LogFactory.getLog(Lavoir90Challenge.class);

    public static void main(String[] args) throws ArgumentsParserException {
        List<GcCache> caches;
        GcApiConfig config = new GcApiConfig();
        config.get().parse(args);
        Path gpxPath = config.getMyFindsGpx();
        Path myDbPath = config.getMyFindsJson();
        if (Files.exists(myDbPath, new LinkOption[0])) {
            log.info((Object)("Loading " + myDbPath));
            caches = new GcCacheService().loadCaches(myDbPath.toFile());
        } else if (Files.exists(gpxPath, new LinkOption[0])) {
            log.info((Object)("Loading " + gpxPath));
            caches = new GpxService().getCaches(gpxPath.toFile());
        } else {
            throw new IllegalStateException("Nothing found to load.");
        }
        log.info((Object)("Load " + caches.size() + " cache(s)."));
        List lavoirsCaches = caches.stream().filter(c -> c.getDesc().toLowerCase().contains("lavoir")).collect(Collectors.toList());
        Set types = lavoirsCaches.stream().map(GcCache::getGcType).collect(Collectors.toSet());
        double score = lavoirsCaches.stream().mapToDouble(c -> c.getDifficulty() + c.getTerrain()).sum();
        StringBuilder result = new StringBuilder("\n");
        result.append("# Summary #\n\n");
        result.append(String.format("\nFound %d \u00abLavoir\u00bb caches.", lavoirsCaches.size()));
        result.append(String.format("\nFound %d different types of \u00abLavoir\u00bb caches : %s", types.size(), types));
        result.append(String.format("\nYour score is %s.", score));
        result.append("\n\n# Details #\n\n");
        float totalScore = 0.0f;
        for (GcCache lavoir : lavoirsCaches) {
            float cacheScore = lavoir.getDifficulty() + lavoir.getTerrain();
            result.append(String.format("\n * [%s - %s - %s points] \u00ab%s\u00bb = %s", lavoir.getGcType(), lavoir.getGcName(), Float.valueOf(totalScore += cacheScore), lavoir.getDesc(), Float.valueOf(cacheScore)));
        }
        log.info((Object)result.toString());
    }
}

