package io.ultreia.gc.service;

/*-
 * #%L
 * GC toolkit :: API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.config.GcApiConfig;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcTrackable;
import io.ultreia.gc.session.GcSession;
import java.lang.reflect.Type;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ArgumentsParserException;

/**
 * Created by tchemit on 25/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcTrackableService extends GcServiceSupport {

    /** Logger. */
    private static final Log log = LogFactory.getLog(GcTrackableService.class);

    public Set<GcTrackable> getTrackables() {

        GcSession gcSession = getGcSession();

        GcRequest request = gcSession.forGet("https://www.geocaching.com/api/proxy/trackables?inCollection=false")
                .addAuthToken()
                .build();

        GcResponse build = gcSession.executeRequest(request);

        Type type = new TypeToken<Set<GcTrackable>>() {

        }.getType();
        return build.getResponseAsJson(type);

    }

    public static void main(String[] args) throws ArgumentsParserException {

        GcApiConfig config = new GcApiConfig();
        config.get().parse(args);

        String sessionId = new GcAuthService().login(config.getLogin(), config.getPassword());
        log.info("SessionId: " + sessionId);

        GcServiceContext serviceContext = GcServiceContext.create(sessionId);
        GcTrackableService service = new GcTrackableService();
        service.setServiceContext(serviceContext);

        Set<GcTrackable> trackables = service.getTrackables();
        log.info("trackables: " + trackables.size());

    }
}
