package io.ultreia.gc.service;

/*-
 * #%L
 * GC toolkit :: API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcRequestBuilder;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcTrackable;
import io.ultreia.gc.session.GcSession;
import io.ultreia.gc.session.GcSessionsStore;
import java.util.Optional;
import java.util.Set;

/**
 * Created by tchemit on 16/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class GcServiceSupport {

    GcServiceContext serviceContext;

    public void setServiceContext(GcServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    GcSession getGcSession() {
        Optional<String> optionalAuthId = serviceContext.getAuthId();
        if (!optionalAuthId.isPresent()) {
            throw new RuntimeException("No authId found in service context");
        }
        Optional<GcSession> session = GcSessionsStore.get().getSession(optionalAuthId.get());
        if (!session.isPresent()) {
            throw new RuntimeException("session not found for authId: " + optionalAuthId.get());
        }
        return session.get();
    }

    public Set<GcTrackable> getTrackables() {
        return getGcSession().getTrackables();
    }

    public String getUsername() {
        return getGcSession().getUsername();
    }

    public GcRequestBuilder forGet(String baseUrl) {
        return getGcSession().forGet(baseUrl);
    }

    public GcRequestBuilder forPost(String baseUrl) {
        return getGcSession().forPost(baseUrl);
    }

    public GcRequestBuilder forDelete(String baseUrl) {
        return getGcSession().forDelete(baseUrl);
    }

    public GcRequestBuilder forPatch(String baseUrl) {
        return getGcSession().forPatch(baseUrl);
    }

    public GcResponse executeRequest(GcRequest request) {
        return getGcSession().executeRequest(request);
    }

    public GcResponse executeRequest(GcRequest request, int expectedStatusCode) {
        GcResponse response = getGcSession().executeRequest(request);
        checkStatusCode(response, expectedStatusCode);
        return response;
    }

    void checkStatusCode(GcResponse response, int expectedStatusCode) {
        if (response.getStatusCode() != expectedStatusCode) {
            throw new IllegalStateException(String.format("Should have a %d status code, but got %d", expectedStatusCode, response.getStatusCode()));
        }
    }
}
