package io.ultreia.gc.service;

/*-
 * #%L
 * GC toolkit :: API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.model.GcLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

/**
 * Created by tchemit on 18/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcCacheService extends GcServiceSupport {

    /** Logger. */
    private static final Log log = LogFactory.getLog(GcCacheService.class);

    public void storeCaches(List<GcCache> caches, File output) {

        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(output.toPath())) {
            gson.toJson(caches, writer);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

    }

    public List<GcCache> loadCaches(File output) {

        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedReader reader = Files.newBufferedReader(output.toPath())) {
            Type type = new TypeToken<List<GcCache>>() {

            }.getType();
            return gson.fromJson(reader, type);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

    }

    public void getCacheFromGuid(String guid) {

        GcRequest request = forGet("https://www.geocaching.com/seek/cache_details.aspx")
                .addParameter("guid", guid)
                .build();
        GcResponse build = executeRequest(request);

        Document doc = build.getResponseAsHtml();

        String userToken;
        String logs;
        List<GcLog> allLogs = new LinkedList<>();
        for (Element element : doc.select("script[type='text/javascript']")) {
            String text = element.data();
            if (text.contains("userToken = '")) {
                int i = text.indexOf("userToken =");
                int start = text.indexOf("'", i) + 1;
                int end = text.indexOf("'", start);
                userToken = text.substring(start, end);
                log.info("User token: " + userToken);

                i = text.indexOf("initalLogs = ");
                start = text.indexOf("{", i);
                end = text.indexOf("};", start) + 1;
                logs = text.substring(start, end);
                HashMap hashMap = new GsonBuilder().setPrettyPrinting().create().fromJson(logs, HashMap.class);

                List data = (List) hashMap.get("data");
                for (Object datum : data) {
                    GcLog gcLog = GcLog.fromMap((Map<String, Object>) datum);
                    allLogs.add(gcLog);
                }
                log.info("logs: " + hashMap);
            }
        }

        String uploadUrl = doc.select("a[title='Upload Image']").attr("href");

        log.info("Upload image url: " + uploadUrl);

    }

    public GcCache getCacheRefFromGcName(String gcName) {

        GcRequest request = forGet("https://www.geocaching.com/api/proxy/web/v1/geocache/" + gcName)
                .addAuthToken()
                .build();

        GcResponse response = executeRequest(request);
        Document responseAsHtml = response.getResponseAsHtml();
        return GcCache.fromXml(responseAsHtml);
    }
}
