package io.ultreia.gc.model;

/*-
 * #%L
 * GC toolkit :: API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * created by tchemit on 18/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcLog {

    public static GcLog fromMap(Map map) {
        GcLog result = new GcLog();
        result.setLogId(((Double) map.get("LogID")).longValue());
        result.setCacheId(((Double) map.get("CacheID")).longValue());
        result.setLogGuid((String) map.get("LogGuid"));
        result.setLogType((String) map.get("LogType"));
        result.setLogText((String) map.get("LogText"));
        result.setCreated((String) map.get("Created"));
        result.setUserName((String) map.get("UserName"));
        return result;
    }

    private long logId;
    private long cacheId;
    private String logGuid;
    private String logType;
    private String logText;
    private String created;
    private String userName;

    public boolean isFoundByUser(String userName) {
        return isFoundIt() && getUserName().equals(userName);
    }

    public boolean isFoundIt() {
        return logType.equals("Found it");
    }

    public long getLogId() {
        return logId;
    }

    public void setLogId(long logId) {
        this.logId = logId;
    }

    public long getCacheId() {
        return cacheId;
    }

    public void setCacheId(long cacheId) {
        this.cacheId = cacheId;
    }

    public String getLogGuid() {
        return logGuid;
    }

    public void setLogGuid(String logGuid) {
        this.logGuid = logGuid;
    }

    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogText() {
        return logText;
    }

    public void setLogText(String logText) {
        this.logText = logText;
    }

    public String getCreated() {
        return created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public final transient DateFormat df = new SimpleDateFormat("dd/MM/yyyy");

    public synchronized Date getDate() {
        try {
            return df.parse(created);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
