package io.ultreia.gc.model;

/*-
 * #%L
 * GC toolkit :: API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Set;
import org.jsoup.nodes.Document;

/**
 * Created by tchemit on 19/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcCache {

    private String gcName;
    private String lat;
    private String oldLat;
    private String lon;
    private String oldLon;
    private String time;
    private String desc;
    private String url;
    private String urlname;
    private String sym;
    private String gpxType;
    private String gcType;
    private String gcId;
    private boolean available = true;
    private boolean archived;
    private String placedby;
    private String ownerId;
    private String owner;
    private String container;
    private float difficulty;
    private float terrain;
    private String country;
    private String state;
    private boolean shortDescHtml = true;
    private String shortDesc;
    private boolean longDescHtml = true;
    private String longDesc;
    private String hint;
    private boolean isPremium;
    private int favPoints;
    private String userNote;
    private Set<String> logs;
    private Set<String> attributes;
    private Set<String> waypoints;
    private boolean hasGsakExt = true;

    public String getGcName() {
        return gcName;
    }

    public void setGcName(String gcName) {
        this.gcName = gcName;
    }

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getOldLat() {
        return oldLat;
    }

    public void setOldLat(String oldLat) {
        this.oldLat = oldLat;
    }

    public String getLon() {
        return lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public String getOldLon() {
        return oldLon;
    }

    public void setOldLon(String oldLon) {
        this.oldLon = oldLon;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlname() {
        return urlname;
    }

    public void setUrlname(String urlname) {
        this.urlname = urlname;
    }

    public String getSym() {
        return sym;
    }

    public void setSym(String sym) {
        this.sym = sym;
    }

    public String getGpxType() {
        return gpxType;
    }

    public void setGpxType(String gpxType) {
        this.gpxType = gpxType;
    }

    public String getGcType() {
        return gcType;
    }

    public void setGcType(String gcType) {
        this.gcType = gcType;
    }

    public String getGcId() {
        return gcId;
    }

    public void setGcId(String gcId) {
        this.gcId = gcId;
    }

    public boolean isAvailable() {
        return available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isArchived() {
        return archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public String getPlacedby() {
        return placedby;
    }

    public void setPlacedby(String placedby) {
        this.placedby = placedby;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getContainer() {
        return container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public float getDifficulty() {
        return difficulty;
    }

    public void setDifficulty(float difficulty) {
        this.difficulty = difficulty;
    }

    public float getTerrain() {
        return terrain;
    }

    public void setTerrain(float terrain) {
        this.terrain = terrain;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isShortDescHtml() {
        return shortDescHtml;
    }

    public void setShortDescHtml(boolean shortDescHtml) {
        this.shortDescHtml = shortDescHtml;
    }

    public String getShortDesc() {
        return shortDesc;
    }

    public void setShortDesc(String shortdesc) {
        this.shortDesc = shortdesc;
    }

    public boolean isLongDescHtml() {
        return longDescHtml;
    }

    public void setLongDescHtml(boolean longDescHtml) {
        this.longDescHtml = longDescHtml;
    }

    public String getLongDesc() {
        return longDesc;
    }

    public void setLongDesc(String longDesc) {
        this.longDesc = longDesc;
    }

    public String getHint() {
        return hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public boolean isPremium() {
        return isPremium;
    }

    public void setPremium(boolean premium) {
        isPremium = premium;
    }

    public int getFavPoints() {
        return favPoints;
    }

    public void setFavPoints(int favPoints) {
        this.favPoints = favPoints;
    }

    public String getUserNote() {
        return userNote;
    }

    public void setUserNote(String userNote) {
        this.userNote = userNote;
    }

    public Set<String> getLogs() {
        return logs;
    }

    public void setLogs(Set<String> logs) {
        this.logs = logs;
    }

    public Set<String> getAttributes() {
        return attributes;
    }

    public void setAttributes(Set<String> attributes) {
        this.attributes = attributes;
    }

    public Set<String> getWaypoints() {
        return waypoints;
    }

    public void setWaypoints(Set<String> waypoints) {
        this.waypoints = waypoints;
    }

    public boolean isHasGsakExt() {
        return hasGsakExt;
    }

    public void setHasGsakExt(boolean hasGsakExt) {
        this.hasGsakExt = hasGsakExt;
    }

    public static GcCache fromXml(Document responseAsHtml) {
        GcCache gcCache = new GcCache();
        gcCache.setGcName(responseAsHtml.select("ReferenceCode").get(0).text());
        gcCache.setGcId(responseAsHtml.select("Id").text());

        gcCache.setLat(responseAsHtml.select("PostedCoordinates > Latitude").text());
        gcCache.setLon(responseAsHtml.select("PostedCoordinates > Longitude").text());

        gcCache.setOwnerId(responseAsHtml.select("Owner > Id").text());
        gcCache.setOwner(responseAsHtml.select("Owner > ReferenceCode").text());
        gcCache.setGcType(responseAsHtml.select("GeocacheType > Name").text());
        return gcCache;
    }
}
