package io.ultreia.gc.http;

/*
 * #%L
 * GC toolkit :: API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

/**
 * Created on 06/09/15.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GcRequest {

    private final String requestMethod;

    private final String baseUrl;

    private final String contentType;

    private final String requestBody;

    private final Map<String, String> headers;

    private final List<NameValuePair> parameters;

    private final Map<String, File> files;

    private final int timeout;
    private final boolean useMultipartForm;

    GcRequest(String requestMethod,
              String baseUrl,
              String requestBody,
              String contentType,
              Map<String, String> header,
              List<NameValuePair> params,
              Map<String, File> files,
              int timeout, boolean useMultipartForm) {
        this.requestMethod = requestMethod;
        this.baseUrl = baseUrl;
        this.requestBody = requestBody;
        this.contentType = contentType;
        this.headers = Collections.unmodifiableMap(header);
        this.parameters = Collections.unmodifiableList(params);
        this.files = Collections.unmodifiableMap(files);
        this.timeout = timeout;
        this.useMultipartForm = useMultipartForm;
    }

    public String getRequestMethod() {
        return requestMethod;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public String getContentType() {
        return contentType;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public List<NameValuePair> getParameters() {
        return parameters;
    }

    public Map<String, File> getFiles() {
        return files;
    }

    public boolean withoutFiles() {
        return files.isEmpty();
    }

    public int getTimeout() {
        return timeout;
    }

    public boolean isUseMultipartForm() {
        return useMultipartForm;
    }
}
