/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.ui;

import io.ultreia.gc.service.GcAuthService;
import io.ultreia.gc.ui.AfterLoginUI;
import io.ultreia.gc.ui.GcConfig;
import java.lang.reflect.Field;
import javax.swing.JButton;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.PasswordStore;

public class LoginPanelUI<C extends GcConfig>
extends JXLoginPane {
    private final C config;

    public static <C extends GcConfig> LoginPanelUI create(AfterLoginUI ui, C config, GcAuthService authService) {
        return new LoginPanelUI<C>(ui, config, authService);
    }

    private LoginPanelUI(AfterLoginUI ui, C config, GcAuthService authService) {
        InternalLoginService service = new InternalLoginService(authService);
        this.setLoginService(service);
        this.config = config;
        this.setSaveMode(JXLoginPane.SaveMode.BOTH);
        this.setBannerText("Geocaching.com");
        this.setPasswordStore(new InternalPasswordStore());
        this.addPropertyChangeListener("status", evt -> {
            JXLoginPane.Status newValue = (JXLoginPane.Status)evt.getNewValue();
            if (JXLoginPane.Status.SUCCEEDED.equals((Object)newValue)) {
                ui.afterLogin(service.getAuthId());
            }
        });
    }

    public void init(boolean autoLogin) {
        this.setUserName(this.config.getLogin());
        String password = this.config.getPassword();
        if (password != null) {
            this.setPassword(password.toCharArray());
        }
        this.setStatus(JXLoginPane.Status.NOT_STARTED);
        if (autoLogin) {
            try {
                Field field = JXLoginPane.class.getDeclaredField("buttonPanel");
                field.setAccessible(true);
                JXPanel buttonPanel = (JXPanel)field.get((Object)this);
                ((JButton)buttonPanel.getComponent(0)).doClick();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class InternalPasswordStore
    extends PasswordStore {
        private InternalPasswordStore() {
        }

        public boolean set(String username, String server, char[] password) {
            LoginPanelUI.this.config.setLogin(username);
            LoginPanelUI.this.config.setPassword(new String(password));
            LoginPanelUI.this.config.get().saveForUser(new String[0]);
            return true;
        }

        public char[] get(String username, String server) {
            String password = LoginPanelUI.this.config.getPassword();
            return password == null ? new char[]{} : password.toCharArray();
        }

        public void removeUserPassword(String username) {
        }
    }

    public class InternalLoginService
    extends LoginService {
        private final GcAuthService authService;
        String authId;

        InternalLoginService(GcAuthService authService) {
            this.authService = authService;
        }

        String getAuthId() {
            return this.authId;
        }

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            try {
                this.authId = this.authService.login(name, new String(password));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

