/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.ui;

import io.ultreia.gc.service.FieldNotesService;
import io.ultreia.gc.service.GcAuthService;
import io.ultreia.gc.service.GcCacheService;
import io.ultreia.gc.service.GcLogService;
import io.ultreia.gc.service.GcServiceContext;
import io.ultreia.gc.service.GpxService;
import io.ultreia.gc.session.GcSessionsStore;
import io.ultreia.gc.ui.GcConfig;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GcApplicationContextSupport<C extends GcConfig>
extends GcServiceContext
implements Closeable {
    private static final Log log = LogFactory.getLog(GcApplicationContextSupport.class);
    private final C config;

    protected GcApplicationContextSupport(C config) {
        this.config = config;
    }

    public GcAuthService newAuthService() {
        GcAuthService service = new GcAuthService();
        service.setServiceContext(this);
        return service;
    }

    public GcCacheService newGcCacheService() {
        GcCacheService service = new GcCacheService();
        service.setServiceContext(this);
        return service;
    }

    public GcLogService newGcLogService() {
        GcLogService service = new GcLogService();
        service.setServiceContext(this);
        return service;
    }

    public GpxService newGpxService() {
        GpxService service = new GpxService();
        service.setServiceContext(this);
        return service;
    }

    public FieldNotesService newFieldNotesService() {
        FieldNotesService service = new FieldNotesService();
        service.setServiceContext(this);
        return service;
    }

    public C getConfig() {
        return this.config;
    }

    @Override
    public void close() {
        this.getAuthId().ifPresent(a -> this.newAuthService().logout());
        GcSessionsStore.get().close();
        try {
            Method method = SwingWorker.class.getDeclaredMethod("getWorkersExecutorService", new Class[0]);
            method.setAccessible(true);
            ExecutorService invoke = (ExecutorService)method.invoke(null, new Object[0]);
            log.info((Object)("close executor service: " + invoke));
            invoke.shutdown();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

