/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.session;

import io.ultreia.gc.session.GcSession;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class GcSessionsStore
implements Closeable {
    private static final GcSessionsStore INSTANCE = new GcSessionsStore();
    private final Set<GcSession> sessions = new LinkedHashSet<GcSession>();

    public static GcSessionsStore get() {
        return INSTANCE;
    }

    public Optional<GcSession> getSession(String authId) {
        return this.sessions.stream().filter(s -> Objects.equals(s.getId(), authId)).findAny();
    }

    public GcSession getSession(String username, String password) {
        Optional<GcSession> gcSession = this.sessions.stream().filter(s -> Objects.equals(username, s.getUsername())).findAny();
        if (gcSession.isPresent()) {
            return gcSession.get();
        }
        GcSession gcSession1 = new GcSession(username, password);
        this.sessions.add(gcSession1);
        return gcSession1;
    }

    public void removeSession(String authId) {
        this.getSession(authId).ifPresent(this.sessions::remove);
    }

    @Override
    public void close() {
        this.sessions.forEach(GcSession::close);
    }
}

