/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.session;

import io.ultreia.gc.http.GcExecuteRequestException;
import io.ultreia.gc.http.GcLoginException;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcRequestBuilder;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.http.GcResponseBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Document;

public class GcSession
implements Closeable {
    private static final Log log = LogFactory.getLog(GcSession.class);
    private static final Map<String, String> HEADERS = new LinkedHashMap<String, String>();
    private final GcResponseBuilder responseBuilder = GcResponseBuilder.create();
    private final String username;
    private final String id;

    public GcRequestBuilder forGet() {
        return GcRequestBuilder.forGet().addHeaders(HEADERS);
    }

    public GcRequestBuilder forPost() {
        return GcRequestBuilder.forPost().addHeaders(HEADERS);
    }

    GcSession(String username, String password) {
        GcResponse build1;
        GcResponse build;
        this.username = username;
        this.id = UUID.randomUUID().toString();
        GcRequest request = this.forGet().build("https://www.geocaching.com/account/login");
        try {
            build = this.responseBuilder.executeRequest(request);
        }
        catch (IOException e) {
            throw new GcLoginException("can't get login page", e);
        }
        Document doc = build.getResponseAsHtml();
        String requestVerificationToken = doc.select("input[name='__RequestVerificationToken'][type='hidden']").attr("value");
        log.debug((Object)("User requestVerificationToken: " + requestVerificationToken));
        GcRequest request1 = GcRequestBuilder.forPost().addHeaders(HEADERS).addParameter("UserName", username).addParameter("Password", password).addParameter("__RequestVerificationToken", requestVerificationToken).build("https://www.geocaching.com/account/login");
        try {
            build1 = this.responseBuilder.executeRequest(request1);
        }
        catch (IOException e) {
            throw new GcLoginException("can't submit login page", e);
        }
        log.debug((Object)("status code: " + build1.getStatusCode()));
        log.debug((Object)("headers: " + Arrays.toString(build1.getResponseHeaders())));
        if (build1.getStatusCode() != 302) {
            throw new GcLoginException(build1.getResponseAsString());
        }
        log.info((Object)"Log in.");
    }

    public GcResponse executeRequest(GcRequest request) {
        try {
            return this.responseBuilder.executeRequest(request);
        }
        catch (IOException e) {
            throw new GcExecuteRequestException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.responseBuilder.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcSession gcSession = (GcSession)o;
        return Objects.equals(this.id, gcSession.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    static {
        HEADERS.put("User-Agent", "Mozilla/5.0 (Windows NT 6.1; rv:48.0) Gecko/20100101 Firefox/48.0");
        HEADERS.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        HEADERS.put("Accept-Language", "fr-fr,en-us;q=0.7,en;q=0.3");
        HEADERS.put("DNT", "1");
        HEADERS.put("Connection", "keep-alive");
    }
}

