/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import io.ultreia.gc.service.GcServiceSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;

public class GpxService
extends GcServiceSupport {
    public Set<String> getGcNames(File gpxFile) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (BufferedReader read = Files.newBufferedReader(gpxFile.toPath());){
            String line = null;
            while ((line = read.readLine()) != null) {
                int i = line.indexOf("<name>");
                if (i <= -1 || line.contains("Project")) continue;
                String gcName = line.substring(i + "<name>".length(), line.indexOf("</name>", i));
                result.add(gcName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void main(String ... args) throws IOException {
        GpxService service = new GpxService();
        Set<String> gcNames = service.getGcNames(Paths.get(args[0], new String[0]).toFile());
        System.out.println(gcNames.size());
    }
}

