/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.service;

import com.google.gson.GsonBuilder;
import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.model.GcLog;
import io.ultreia.gc.service.GcServiceSupport;
import io.ultreia.gc.session.GcSession;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class GcCacheService
extends GcServiceSupport {
    private static final Log log = LogFactory.getLog(GcCacheService.class);

    public void getCacheFromGuid(String guid) {
        GcSession gcSession = this.getGcSession();
        GcRequest request = gcSession.forGet().addParameter("guid", guid).build("https://www.geocaching.com/seek/cache_details.aspx");
        GcResponse build = gcSession.executeRequest(request);
        Document doc = build.getResponseAsHtml();
        String userToken = null;
        String logs = null;
        LinkedList<GcLog> allLogs = new LinkedList<GcLog>();
        for (Element element : doc.select("script[type='text/javascript']")) {
            String text = element.data();
            if (!text.contains("userToken = '")) continue;
            int i = text.indexOf("userToken =");
            int start = text.indexOf("'", i) + 1;
            int end = text.indexOf("'", start);
            userToken = text.substring(start, end);
            log.info((Object)("User token: " + userToken));
            i = text.indexOf("initalLogs = ");
            start = text.indexOf("{", i);
            end = text.indexOf("};", start) + 1;
            logs = text.substring(start, end);
            HashMap hashMap = (HashMap)new GsonBuilder().setPrettyPrinting().create().fromJson(logs, HashMap.class);
            List data = (List)hashMap.get("data");
            for (Object datum : data) {
                GcLog gcLog = GcLog.fromMap((Map)datum);
                allLogs.add(gcLog);
            }
            log.info((Object)("logs: " + hashMap));
        }
        String uploadUrl = doc.select("a[title='Upload Image']").attr("href");
        log.info((Object)("Upload image url: " + uploadUrl));
    }
}

