/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.http;

import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.http.GcResponseNotAvailableException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;

public class GcResponseBuilder
implements Closeable {
    private static final Log log = LogFactory.getLog(GcResponseBuilder.class);
    private final CloseableHttpClient client;
    private final BasicCookieStore cookieStore;

    public static GcResponseBuilder create() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient build = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).setConnectionTimeToLive(45L, TimeUnit.SECONDS).build();
        return new GcResponseBuilder(build, cookieStore);
    }

    public GcResponse executeRequest(GcRequest request) throws IOException {
        String requestMethod;
        switch (requestMethod = request.getRequestMethod()) {
            case "GET": {
                return this.get0(request);
            }
            case "POST": {
                return this.post0(request);
            }
            case "PUT": {
                return this.put0(request);
            }
            case "DELETE": {
                return this.delete0(request);
            }
        }
        throw new IllegalStateException("Can't come here!");
    }

    private GcResponseBuilder(CloseableHttpClient client, BasicCookieStore cookieStore) {
        this.client = client;
        this.cookieStore = cookieStore;
    }

    private GcResponse get0(GcRequest request) throws IOException {
        String baseUrl = request.getBaseUrl();
        String url = this.buildUrlWithParameters(baseUrl, request.getParameters());
        HttpGet getMethod = new HttpGet(url);
        this.addTimeoutToRequest((HttpRequestBase)getMethod, request.getTimeout());
        this.addHeaders(getMethod, request.getHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)getMethod);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET '" + baseUrl + "' return status code : " + response.getStatusLine().getStatusCode()));
        }
        return this.consumeResponse(request, (HttpRequestBase)getMethod, response);
    }

    private GcResponse post0(GcRequest request) throws IOException {
        String baseUrl = request.getBaseUrl();
        String contentType = request.getContentType();
        String requestBody = request.getRequestBody();
        HttpPost postMethod = new HttpPost(baseUrl);
        this.addTimeoutToRequest((HttpRequestBase)postMethod, request.getTimeout());
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        if (contentType == null || contentType.trim().isEmpty()) {
            contentType = "text/plain";
        }
        if (request.withoutFiles()) {
            this.addHeaders(postMethod, request.getHeaders());
            this.addRequestBody(postMethod, contentType, requestBody);
            for (NameValuePair nameValuePair : request.getParameters()) {
                entityBuilder.addTextBody(nameValuePair.getName(), nameValuePair.getValue(), ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8));
            }
        } else {
            this.addHeaders(postMethod, request.getHeaders());
            this.addRequestBody(postMethod, contentType, requestBody);
            for (Map.Entry entry : request.getFiles().entrySet()) {
                entityBuilder.addBinaryBody((String)entry.getKey(), (File)entry.getValue());
            }
            for (NameValuePair nameValuePair : request.getParameters()) {
                entityBuilder.addTextBody(nameValuePair.getName(), nameValuePair.getValue(), ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8));
            }
        }
        postMethod.setEntity(entityBuilder.build());
        HttpResponse response = this.executeRequest((HttpRequestBase)postMethod);
        if (log.isDebugEnabled()) {
            log.debug((Object)("POST '" + baseUrl + "' return status code : " + response.getStatusLine().getStatusCode()));
        }
        return this.consumeResponse(request, (HttpRequestBase)postMethod, response);
    }

    private GcResponse put0(GcRequest request) throws IOException {
        String baseUrl = request.getBaseUrl();
        HttpPut putMethod = new HttpPut(baseUrl);
        this.addHeaders(putMethod, request.getHeaders());
        this.addTimeoutToRequest((HttpRequestBase)putMethod, request.getTimeout());
        String contentType = request.getContentType();
        this.addParameters(putMethod, contentType, request.getParameters());
        this.addRequestBody(putMethod, contentType, request.getRequestBody());
        HttpResponse response = this.executeRequest((HttpRequestBase)putMethod);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PUT '" + baseUrl + "' return status code : " + response.getStatusLine().getStatusCode()));
        }
        return this.consumeResponse(request, (HttpRequestBase)putMethod, response);
    }

    private GcResponse delete0(GcRequest request) throws IOException {
        String baseUrl = request.getBaseUrl();
        HttpDelete deleteMethod = new HttpDelete(this.buildUrlWithParameters(baseUrl, request.getParameters()));
        this.addHeaders(deleteMethod, request.getHeaders());
        this.addTimeoutToRequest((HttpRequestBase)deleteMethod, request.getTimeout());
        HttpResponse response = this.executeRequest((HttpRequestBase)deleteMethod);
        if (log.isDebugEnabled()) {
            log.debug((Object)("DELETE '" + baseUrl + "' return status code : " + response.getStatusLine().getStatusCode()));
        }
        return this.consumeResponse(request, (HttpRequestBase)deleteMethod, response);
    }

    private HttpResponse executeRequest(HttpRequestBase request) throws IOException, GcResponseNotAvailableException {
        try {
            return this.client.execute((HttpUriRequest)request);
        }
        catch (ConnectException | UnknownHostException e) {
            throw new GcResponseNotAvailableException(request.getURI().toURL());
        }
    }

    private GcResponse consumeResponse(GcRequest request, HttpRequestBase httpRequestBase, HttpResponse response) throws IOException {
        String responseAsString;
        String baseUrl = request.getBaseUrl();
        Header[] responseHeaders = response.getAllHeaders();
        int statusCode = response.getStatusLine().getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)(request.getRequestMethod() + " '" + baseUrl + "' return status code : " + statusCode));
        }
        try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
            response.getEntity().writeTo((OutputStream)writer);
            responseAsString = writer.toString();
        }
        return new GcResponse(httpRequestBase, response, statusCode, responseAsString, responseHeaders);
    }

    private String buildUrlWithParameters(String baseUrl, List<NameValuePair> parameters) {
        String result = baseUrl;
        if (!parameters.isEmpty()) {
            result = result + "?" + URLEncodedUtils.format(parameters, (Charset)StandardCharsets.UTF_8);
        }
        return result;
    }

    private <M extends HttpRequestBase> void addHeaders(M httpMethod, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpMethod.setHeader(entry.getKey(), entry.getValue());
        }
    }

    private <M extends HttpEntityEnclosingRequestBase> void addParameters(M method, String contentType, List<? extends NameValuePair> parameters) {
        UrlEncodedFormEntity encodedFormEntity = new UrlEncodedFormEntity(parameters, StandardCharsets.UTF_8);
        if (!contentType.trim().isEmpty()) {
            encodedFormEntity.setContentType(contentType);
        }
        method.setEntity((HttpEntity)encodedFormEntity);
    }

    private <M extends HttpEntityEnclosingRequestBase> void addRequestBody(M method, String contentType, String requestBody) throws UnsupportedEncodingException {
        if (requestBody != null && !requestBody.trim().isEmpty()) {
            if (!contentType.trim().isEmpty()) {
                method.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.parse((String)contentType)));
            } else {
                method.setEntity((HttpEntity)new StringEntity(requestBody));
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    protected void finalize() throws Throwable {
        try {
            this.client.close();
        }
        finally {
            super.finalize();
        }
    }

    private void addTimeoutToRequest(HttpRequestBase httpRequestBase, int timeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add custom timeout: " + timeout));
        }
        httpRequestBase.setConfig(requestConfig);
    }

    public void setCookie(String name, String value) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(".geocaching.com");
        cookie.setPath("/");
        cookie.setSecure(true);
        cookie.setExpiryDate(new Date(new Date().getTime() + 3000L));
        this.cookieStore.addCookie((Cookie)cookie);
    }
}

