/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.http;

import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class GcResponse
implements Closeable {
    private final HttpRequestBase httpRequestBase;
    private final HttpResponse response;
    private final Integer statusCode;
    private final String responseAsString;
    private final Header[] responseHeaders;

    GcResponse(HttpRequestBase httpRequestBase, HttpResponse response, Integer statusCode, String responseAsString, Header ... responseHeaders) {
        this.httpRequestBase = httpRequestBase;
        this.response = response;
        this.statusCode = statusCode;
        this.responseAsString = responseAsString;
        this.responseHeaders = responseHeaders;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getResponseAsString() {
        return this.responseAsString;
    }

    public Header[] getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.response != null && this.response.getEntity() != null) {
                this.response.getEntity().getContent().close();
            }
        }
        finally {
            this.httpRequestBase.releaseConnection();
        }
    }

    public Document getResponseAsHtml() {
        return Jsoup.parse((String)this.responseAsString);
    }

    public Map<String, Object> getResponseAsJson() {
        Map hashMap = (Map)new GsonBuilder().setPrettyPrinting().create().fromJson(this.responseAsString, HashMap.class);
        return hashMap;
    }
}

