/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.http;

import io.ultreia.gc.http.GcRequest;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class GcRequestBuilder {
    protected final List<NameValuePair> parameters;
    protected final Map<String, String> headers;
    protected final Map<String, File> files;
    protected String requestBody;
    protected String contentType;
    protected String requestMethod;
    protected int timeout = 30000;

    public static GcRequestBuilder forGet() {
        return new GcRequestBuilder("GET");
    }

    public static GcRequestBuilder forPost() {
        return new GcRequestBuilder("POST");
    }

    public static GcRequestBuilder forPut() {
        return new GcRequestBuilder("PUT");
    }

    public static GcRequestBuilder forDelete() {
        return new GcRequestBuilder("DELETE");
    }

    public GcRequest build(String baseUrl) {
        Objects.requireNonNull(baseUrl, "'baseUrl' can't be null");
        Objects.requireNonNull(this.requestMethod, "'requestMethod' was not setted");
        return new GcRequest(this.requestMethod, baseUrl, this.contentType, this.requestBody, this.headers, this.parameters, this.files, this.timeout);
    }

    public GcRequestBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public GcRequestBuilder setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public GcRequestBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public GcRequestBuilder addHeader(String key, String value) {
        this.checkRequestNotNull(key, value);
        this.headers.put(key, value);
        return this;
    }

    public GcRequestBuilder addParameter(String parameterName, String value) {
        this.checkParameterNotNull(parameterName, value);
        this.parameters.add((NameValuePair)new BasicNameValuePair(parameterName, value));
        return this;
    }

    public GcRequestBuilder addHiddenInputs(Document doc) {
        for (Element element : doc.select("input[type='hidden']")) {
            String value = element.attr("value");
            if (value == null) continue;
            this.addParameter(element.attr("name"), value);
        }
        return this;
    }

    private GcRequestBuilder(String methodName) {
        Objects.requireNonNull(methodName);
        this.requestMethod = methodName;
        this.headers = new LinkedHashMap<String, String>();
        this.files = new LinkedHashMap<String, File>();
        this.parameters = new LinkedList<NameValuePair>();
    }

    protected void checkParameterNotNull(String parparameterNamemName, Object value) {
        this.checkKeyValueNotNull(parparameterNamemName, value, "Parameter key must be not null", "Parameter value must be not null for paramName : " + parparameterNamemName);
    }

    protected void checkRequestNotNull(String key, Object value) {
        this.checkKeyValueNotNull(key, value, "Request key must be not null", "Request value must be not null for key : " + key);
    }

    protected void checkKeyValueNotNull(String key, Object value, String keyErrorMessage, String valueErrorMessage) {
        Objects.requireNonNull(key, keyErrorMessage);
        Objects.requireNonNull(value, valueErrorMessage);
    }

    public GcRequestBuilder addCookie(String cookieName, String value) {
        return this;
    }

    public GcRequestBuilder addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
        return this;
    }
}

