/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.http;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class GcRequest {
    private final String requestMethod;
    private final String baseUrl;
    private final String contentType;
    private final String requestBody;
    private final Map<String, String> headers;
    private final List<NameValuePair> parameters;
    private final Map<String, File> files;
    private final int timeout;

    GcRequest(String requestMethod, String baseUrl, String requestBody, String contentType, Map<String, String> header, List<NameValuePair> params, Map<String, File> files, int timeout) {
        this.requestMethod = requestMethod;
        this.baseUrl = baseUrl;
        this.requestBody = requestBody;
        this.contentType = contentType;
        this.headers = Collections.unmodifiableMap(header);
        this.parameters = Collections.unmodifiableList(params);
        this.files = Collections.unmodifiableMap(files);
        this.timeout = timeout;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters;
    }

    public Map<String, File> getFiles() {
        return this.files;
    }

    public boolean withoutFiles() {
        return this.files.isEmpty();
    }

    public int getTimeout() {
        return this.timeout;
    }
}

