package io.ultreia.gc.service;

/*-
 * #%L
 * GC toolkit :: API
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * Created by tchemit on 18/04/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class GpxService extends GcServiceSupport {

    public Set<String> getGcNames(File gpxFile) {

        Set<String> result = new LinkedHashSet<>();
        try (BufferedReader read = Files.newBufferedReader(gpxFile.toPath())) {
            String line = null;
            while ((line = read.readLine()) != null) {
                int i = line.indexOf("<name>");
                if (i > -1 && !line.contains("Project")) {
                    String gcName = line.substring(i + "<name>".length(), line.indexOf("</name>", i));
                    result.add(gcName);
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void main(String... args) throws IOException {
        GpxService service = new GpxService();
        Set<String> gcNames = service.getGcNames(Paths.get(args[0]).toFile());
        System.out.println(gcNames.size());
    }
}
