/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsutil;

import java.math.BigDecimal;

public class UDPNStringUtil {
    public static boolean isNull(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotNull(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static boolean isNumberOrCharacter(String str) {
        String regex = "^[0-9A-Za-z]+$";
        return str.matches(regex);
    }

    public static boolean isServiceFee(BigDecimal value) {
        String str = value.stripTrailingZeros().toPlainString();
        int index = str.indexOf(46);
        if (index < 0 && str.length() > 18) {
            return false;
        }
        return index <= 0 || index <= 18 && str.length() - index - 1 <= 18;
    }

    public static boolean isAmount(BigDecimal value) {
        String str = value.stripTrailingZeros().toPlainString();
        int index = str.indexOf(46);
        if (index < 0 && str.length() > 32) {
            return false;
        }
        return index <= 0 || index <= 32 && str.length() - index - 1 <= 18;
    }

    public static boolean isAmount(BigDecimal value, int currencyPrecision) {
        String str = value.stripTrailingZeros().toPlainString();
        int index = str.indexOf(46);
        if (index < 0 && str.length() > 32) {
            return false;
        }
        return index <= 0 || index <= 32 && str.length() - index - 1 <= currencyPrecision;
    }

    public static int getPrecision(BigDecimal bd) {
        int precision = 0;
        String textBD = bd.toPlainString();
        int radixLoc = textBD.indexOf(46);
        if (radixLoc > 0) {
            precision = textBD.substring(radixLoc + 1).length();
        }
        return precision;
    }
}

