/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsutil;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ServerUtil {
    private static final String IP_REGEX = "(((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?))";
    private static final String DOMAIN_REGEX = ".*\\.(com|xyz|net|top|tech|org|gov|edu|pub|cn|biz|cc|tv|info|im|io)";
    public static final String NAME_REGEX = "[a-zA-Z]{1}\\w{1,49}";

    public static boolean isName(String param) {
        return param.matches(NAME_REGEX);
    }

    public static boolean isHostIp(String host) {
        return host.matches(IP_REGEX);
    }

    public static boolean isHostDomain(String host) {
        return host.matches(String.format("^%s$", DOMAIN_REGEX));
    }

    public static String getScheme(String host) {
        if (host != null) {
            if (host.toLowerCase().startsWith("http://")) {
                return "http";
            }
            if (host.toLowerCase().startsWith("https://")) {
                return "https";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReachable(String ip, Integer port, int timeout) {
        boolean reachable = false;
        if (port == null) {
            try {
                InetAddress address = InetAddress.getByName(ip);
                reachable = address.isReachable(timeout);
            }
            catch (Exception e) {
                e.printStackTrace();
                reachable = false;
            }
        } else {
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(ip, (int)port), timeout);
                reachable = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                reachable = false;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return reachable;
    }
}

