/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsshutdownbootstarter.taskshutdown;

import io.udpn.commonsshutdownbootstarter.support.ContextShutdown;
import io.udpn.commonsshutdownbootstarter.support.ShutdownMarker;
import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskExecutionRegistry;
import io.udpn.commonsshutdownbootstarter.taskshutdown.exception.ShutdownTaskRejectedException;
import java.util.Objects;
import java.util.UUID;

public class TaskWatch {
    private String taskName;
    private String id;
    private long startTime;

    TaskWatch() {
    }

    public static TaskWatch newTaskWatch(String taskName) {
        if (TaskExecutionRegistry.notContainsKey(taskName)) {
            throw new RuntimeException("Task does not exist");
        }
        TaskWatch taskWatch = new TaskWatch();
        taskWatch.setId(UUID.randomUUID().toString());
        taskWatch.setTaskName(taskName);
        return taskWatch;
    }

    public TaskWatch start() {
        if (ShutdownMarker.isShutdown()) {
            throw new ShutdownTaskRejectedException(this.getTaskName() + " Task initiation is rejected");
        }
        this.setStartTime(System.currentTimeMillis());
        TaskExecutionRegistry.put(this);
        return this;
    }

    public void stop() {
        TaskExecutionRegistry.remove(this);
        if (ShutdownMarker.isShutdown()) {
            ContextShutdown.safeShutdown();
        }
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getTaskName() {
        return this.taskName;
    }

    void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskWatch taskWatch = (TaskWatch)o;
        if (!Objects.equals(this.taskName, taskWatch.taskName)) {
            return false;
        }
        return Objects.equals(this.id, taskWatch.id);
    }

    public int hashCode() {
        int result = this.taskName != null ? this.taskName.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }
}

