/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsshutdownbootstarter.taskshutdown;

import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskExecutionRegistry;
import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskWatch;
import io.udpn.commonsshutdownbootstarter.taskshutdown.annotation.TaskMonitor;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.StringUtils;

@Aspect
public class TaskMonitorAspect {
    @Pointcut(value="@annotation(io.udpn.commonsshutdownbootstarter.taskshutdown.annotation.TaskMonitor)")
    public void aspectPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="aspectPointcut()")
    public Object taskMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        TaskMonitor taskMonitor = method.getAnnotation(TaskMonitor.class);
        String taskName = this.getTaskName(method, taskMonitor);
        TaskExecutionRegistry.put(taskName);
        TaskWatch taskWatch = null;
        if (this.isWatch(taskMonitor)) {
            taskWatch = TaskWatch.newTaskWatch(taskName).start();
        }
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            if (taskWatch != null) {
                taskWatch.stop();
            }
        }
    }

    private boolean isWatch(TaskMonitor taskMonitor) {
        return taskMonitor.automatic();
    }

    private String getTaskName(Method method, TaskMonitor taskMonitor) {
        if (StringUtils.isEmpty((Object)taskMonitor.name())) {
            return method.getName();
        }
        return taskMonitor.name();
    }
}

