/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsshutdownbootstarter.taskshutdown;

import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskWatch;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskExecutionRegistry {
    private static final Map<String, Set<TaskWatch>> task = new ConcurrentHashMap<String, Set<TaskWatch>>(256);

    static boolean containsKey(String key) {
        return task.containsKey(key);
    }

    static boolean notContainsKey(String key) {
        return !TaskExecutionRegistry.containsKey(key);
    }

    static void put(String key) {
        if (TaskExecutionRegistry.notContainsKey(key)) {
            TaskExecutionRegistry.initTask(key);
        }
    }

    private static void initTask(String key) {
        task.put(key, ConcurrentHashMap.newKeySet(16));
    }

    static void put(TaskWatch taskWatch) {
        task.get(taskWatch.getTaskName()).add(taskWatch);
    }

    static void remove(TaskWatch taskWatch) {
        task.get(taskWatch.getTaskName()).remove(taskWatch);
    }

    public static boolean isEmpty() {
        for (Map.Entry<String, Set<TaskWatch>> entry : task.entrySet()) {
            Set<TaskWatch> value = entry.getValue();
            if (value.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static Map<String, Set<TaskWatch>> getTask() {
        return task;
    }
}

