/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsshutdownbootstarter.support;

import io.udpn.commonsshutdownbootstarter.support.ShutdownMarker;
import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskExecutionRegistry;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ContextShutdown
implements ApplicationContextAware {
    private static ConfigurableApplicationContext context;

    public static void safeShutdown() {
        ShutdownMarker.setShutdown();
        if (TaskExecutionRegistry.isEmpty()) {
            Thread thread = new Thread(ContextShutdown::performShutdown);
            thread.setContextClassLoader(ContextShutdown.class.getClassLoader());
            thread.start();
        }
    }

    private static void performShutdown() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        context.close();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (context instanceof ConfigurableApplicationContext) {
            ContextShutdown.context = (ConfigurableApplicationContext)context;
        }
    }
}

