/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsshutdownbootstarter.configuration;

import io.udpn.commonsshutdownbootstarter.configuration.ShutdownProperties;
import java.util.List;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CollectionUtils;

public class ThreadPoolShutdownConfiguration
implements ApplicationListener<ContextClosedEvent> {
    private final ShutdownProperties shutdownProperties;
    private List<ExecutorConfigurationSupport> threadPoolList;

    public ThreadPoolShutdownConfiguration(ShutdownProperties shutdownProperties) {
        this.shutdownProperties = shutdownProperties;
    }

    public List<ExecutorConfigurationSupport> getThreadPoolList() {
        return this.threadPoolList;
    }

    public void setThreadPoolList(List<ExecutorConfigurationSupport> threadPoolList) {
        this.threadPoolList = threadPoolList;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.destroyThreadPool();
    }

    private void destroyThreadPool() {
        if (!CollectionUtils.isEmpty(this.threadPoolList)) {
            for (ExecutorConfigurationSupport support : this.threadPoolList) {
                support.setWaitForTasksToCompleteOnShutdown(true);
                support.setAwaitTerminationMillis(this.shutdownProperties.getPoolAwaitTermination().toMillis());
                if (!(support instanceof ThreadPoolTaskScheduler)) continue;
                support.destroy();
            }
        }
    }
}

