/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsshutdownbootstarter.configuration;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ShutdownEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private int order = -2147483637;
    public static final String ENVIRONMENT_NAME = "redshutdown";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("server.shutdown", Shutdown.GRACEFUL);
        map.put("spring.lifecycle.timeout-per-shutdown-phase", Duration.ofSeconds(120L));
        this.setDefaultShutdownEndpoint(map);
        MapPropertySource propertySource = new MapPropertySource(ENVIRONMENT_NAME, map);
        environment.getPropertySources().addLast((PropertySource)propertySource);
    }

    private void setDefaultShutdownEndpoint(LinkedHashMap<String, Object> map) {
        map.put("management.endpoints.web.exposure.include", Arrays.asList("info", "health", ENVIRONMENT_NAME, "taskregistry"));
    }

    public int getOrder() {
        return this.order;
    }
}

