/*
 * Decompiled with CFR 0.152.
 */
package io.udpn.commonsshutdownbootstarter.configuration;

import io.udpn.commonsshutdownbootstarter.configuration.ShutdownProperties;
import io.udpn.commonsshutdownbootstarter.configuration.ThreadPoolShutdownConfiguration;
import io.udpn.commonsshutdownbootstarter.endpoint.RedShutdownEndpoint;
import io.udpn.commonsshutdownbootstarter.support.ContextShutdown;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ShutdownProperties.class})
public class ShutdownConfiguration {
    @Bean
    public ContextShutdown contextShutdown() {
        return new ContextShutdown();
    }

    @ConditionalOnBean(value={ExecutorConfigurationSupport.class})
    protected class ThreadPoolConfiguration {
        @Autowired(required=false)
        private List<ExecutorConfigurationSupport> threadPoolList;

        protected ThreadPoolConfiguration() {
        }

        @Bean
        public ThreadPoolShutdownConfiguration threadPoolShutdownConfiguration(ShutdownProperties shutdownProperties) {
            ThreadPoolShutdownConfiguration threadPoolShutdownConfiguration = new ThreadPoolShutdownConfiguration(shutdownProperties);
            threadPoolShutdownConfiguration.setThreadPoolList(this.threadPoolList);
            return threadPoolShutdownConfiguration;
        }
    }

    @ConditionalOnClass(value={Endpoint.class})
    protected class RedShutdownEndpointConfiguration {
        protected RedShutdownEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public RedShutdownEndpoint redShutdownEndpoint(@Autowired(required=false) Registration registration, @Autowired(required=false) ServiceRegistry serviceRegistry) {
            return new RedShutdownEndpoint(serviceRegistry, registration);
        }
    }
}

