/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.taskshutdown;

import io.udpn.commonsshutdownbootstarter.support.ShutdownMarker;
import io.udpn.commonsshutdownbootstarter.support.ContextShutdown;
import io.udpn.commonsshutdownbootstarter.taskshutdown.exception.ShutdownTaskRejectedException;
import java.util.Objects;
import java.util.UUID;

/**
 * Task monitoring observation
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/1/31
 * @history date, modifier,and description
 **/
public class TaskWatch {

  /**
   * method description
   */
  private String taskName;

  /**
   * Task identification
   */
  private String id;

  /**
   * Task start time
   */
  private long startTime;

  TaskWatch(){}

  public static TaskWatch newTaskWatch(String taskName){
    if(TaskExecutionRegistry.notContainsKey(taskName)){
      throw new RuntimeException("Task does not exist");
    }
    TaskWatch taskWatch = new TaskWatch();
    taskWatch.setId(UUID.randomUUID().toString());
    taskWatch.setTaskName(taskName);
    return taskWatch;
  }

  public TaskWatch start(){
    if(ShutdownMarker.isShutdown()){
      throw new ShutdownTaskRejectedException(this.getTaskName() + " Task initiation is rejected");
    }
    this.setStartTime(System.currentTimeMillis());
    TaskExecutionRegistry.put(this);
    return this;
  }

  public void stop(){
    TaskExecutionRegistry.remove(this);
    if(ShutdownMarker.isShutdown()){
      ContextShutdown.safeShutdown();
    }
  }

  public String getId() {
    return id;
  }

  void setId(String id) {
    this.id = id;
  }

  public String getTaskName() {
    return taskName;
  }

  void setTaskName(String taskName) {
    this.taskName = taskName;
  }

  public long getStartTime() {
    return startTime;
  }

  void setStartTime(long startTime) {
    this.startTime = startTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    TaskWatch taskWatch = (TaskWatch) o;

    if (!Objects.equals(taskName, taskWatch.taskName)) {
      return false;
    }
    return Objects.equals(id, taskWatch.id);
  }

  @Override
  public int hashCode() {
    int result = taskName != null ? taskName.hashCode() : 0;
    result = 31 * result + (id != null ? id.hashCode() : 0);
    return result;
  }

}
