/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.taskshutdown;

import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

/**
 * {@link Endpoint @Endpoint} Task registry operations.
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/2/2
 * @history date, modifier,and description
 **/
@Endpoint(id = TaskRegistryEndpoint.ENDPOINT)
public class TaskRegistryEndpoint {

  public static final String ENDPOINT = "taskregistry";

  @ReadOperation
  public Map<String, Set<TaskWatch>> getRegistry() {
    return TaskExecutionRegistry.getTask();
  }

  @DeleteOperation
  public Boolean deleteTask(String taskName, String taskId) {
    Set<TaskWatch> taskWatchSet = TaskExecutionRegistry.getTask().get(taskName);
    if (taskWatchSet != null) {
      for (TaskWatch taskWatch : taskWatchSet) {
        if (taskWatch.getId().equals(taskId)) {
          taskWatch.stop();
          return true;
        }
      }
    }
    return false;
  }

}
