/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.taskshutdown;

import io.udpn.commonsshutdownbootstarter.taskshutdown.annotation.TaskMonitor;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.StringUtils;

/**
 * Task monitoring aspect
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/2/1
 * @history date, modifier,and description
 **/
@Aspect
public class TaskMonitorAspect {

  @Pointcut("@annotation(io.udpn.commonsshutdownbootstarter.taskshutdown.annotation.TaskMonitor)")
  public void aspectPointcut() {
  }

  @Around(value = "aspectPointcut()")
  public Object taskMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
    // Get execution method
    Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();
    TaskMonitor taskMonitor = method.getAnnotation(TaskMonitor.class);

    // Adding tasks
    String taskName = getTaskName(method, taskMonitor);
    TaskExecutionRegistry.put(taskName);

    // Start task watch
    TaskWatch taskWatch = null;
    if(isWatch(taskMonitor)){
      taskWatch = TaskWatch.newTaskWatch(taskName).start();
    }

    // Execution of business
    try {
      return joinPoint.proceed();
    } finally {
      if(taskWatch != null){
        taskWatch.stop();
      }
    }
  }

  private boolean isWatch(TaskMonitor taskMonitor){
    return taskMonitor.automatic();
  }

  private String getTaskName(Method method, TaskMonitor taskMonitor){
    if(StringUtils.isEmpty(taskMonitor.name())){
      return method.getName();
    }
    return taskMonitor.name();
  }

}
