/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.taskshutdown;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Task registry
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/1/31
 * @history date, modifier,and description
 **/
public class TaskExecutionRegistry {

  private static final Map<String, Set<TaskWatch>> task = new ConcurrentHashMap<>(256);

  static boolean containsKey(String key){
    return task.containsKey(key);
  }

  static boolean notContainsKey(String key){
    return !containsKey(key);
  }

  static void put(String key){
    if(notContainsKey(key)){
      initTask(key);
    }
  }

  private static void initTask(String key){
    task.put(key, ConcurrentHashMap.newKeySet(16));
  }

  static void put(TaskWatch taskWatch){
    task.get(taskWatch.getTaskName()).add(taskWatch);
  }

  static void remove(TaskWatch taskWatch){
    task.get(taskWatch.getTaskName()).remove(taskWatch);
  }

  public static boolean isEmpty(){
    for (Entry<String, Set<TaskWatch>> entry : task.entrySet()) {
      Set<TaskWatch> value = entry.getValue();
      if (!value.isEmpty()) {
        return false;
      }
    }
    return true;
  }

  static Map<String, Set<TaskWatch>> getTask(){
    return task;
  }

}
