/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.support;

import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskExecutionRegistry;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * Context shutdown
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/2/1
 * @history date, modifier,and description
 **/
public class ContextShutdown implements ApplicationContextAware {

  private static ConfigurableApplicationContext context;

  public static void safeShutdown() {
    ShutdownMarker.setShutdown();
    if (TaskExecutionRegistry.isEmpty()) {
      Thread thread = new Thread(ContextShutdown::performShutdown);
      thread.setContextClassLoader(ContextShutdown.class.getClassLoader());
      thread.start();
    }
  }

  private static void performShutdown() {
    try {
      Thread.sleep(500L);
    } catch (InterruptedException ex) {
      Thread.currentThread().interrupt();
    }
    ContextShutdown.context.close();
  }

  @Override
  public void setApplicationContext(ApplicationContext context) throws BeansException {
    if (context instanceof ConfigurableApplicationContext) {
      ContextShutdown.context = (ConfigurableApplicationContext) context;
    }
  }

}
