/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.event;

import org.springframework.context.ApplicationEvent;

/**
 * The event raised before {@code ApplicationContext} is closed.
 * <p> Some things can be done before the context is closed,
 * such as logout registrations or actuators, and so on
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/1/25
 * @history date, modifier,and description
 **/
public class RedShutdownEvent extends ApplicationEvent {

  public RedShutdownEvent(Object source) {
    super(source);
  }

}
