/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.configuration;

import java.util.List;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CollectionUtils;

/**
 * Thread pool shutdown
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/1/29
 * @history date, modifier,and description
 **/
public class ThreadPoolShutdownConfiguration implements ApplicationListener<ContextClosedEvent> {

  private final ShutdownProperties shutdownProperties;

  private List<ExecutorConfigurationSupport> threadPoolList;

  public ThreadPoolShutdownConfiguration(ShutdownProperties shutdownProperties) {
    this.shutdownProperties = shutdownProperties;
  }

  public List<ExecutorConfigurationSupport> getThreadPoolList() {
    return threadPoolList;
  }

  public void setThreadPoolList(
      List<ExecutorConfigurationSupport> threadPoolList) {
    this.threadPoolList = threadPoolList;
  }

  @Override
  public void onApplicationEvent(ContextClosedEvent event) {
    destroyThreadPool();
  }

  private void destroyThreadPool(){
    if(!CollectionUtils.isEmpty(threadPoolList)){
      for (ExecutorConfigurationSupport support : threadPoolList) {
        support.setWaitForTasksToCompleteOnShutdown(true);
        support.setAwaitTerminationMillis(
            shutdownProperties.getPoolAwaitTermination().toMillis());
        if(support instanceof ThreadPoolTaskScheduler){
          support.destroy();
        }
      }
    }
  }

}
