/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.configuration;

import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskMonitorAspect;
import io.udpn.commonsshutdownbootstarter.taskshutdown.TaskRegistryEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Task execution monitoring configuration
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/2/1
 * @history date, modifier,and description
 **/
@Configuration(proxyBeanMethods = false)
public class TaskMonitorConfiguration {

  @Bean
  public TaskMonitorAspect taskMonitorAspect(){
    return new TaskMonitorAspect();
  }

  @ConditionalOnClass(Endpoint.class)
  protected class TaskRegistryEndpointConfiguration {

    @Bean
    @ConditionalOnAvailableEndpoint
    public TaskRegistryEndpoint taskRegistryEndpoint() {
      return new TaskRegistryEndpoint();
    }

  }

}
