/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.configuration;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * properties
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/1/29
 * @history date, modifier,and description
 **/
@ConfigurationProperties(prefix = ShutdownProperties.PREFIX)
public class ShutdownProperties {

  public static final String PREFIX = "redshutdown";

  private Duration poolAwaitTermination = Duration.ofSeconds(60);


  public Duration getPoolAwaitTermination() {
    return poolAwaitTermination;
  }

  public void setPoolAwaitTermination(Duration poolAwaitTermination) {
    this.poolAwaitTermination = poolAwaitTermination;
  }
}
