/*
 * Copyright 2021 Red Date Technology Ltd.  Licensed under MPLv2
 * (https://www.mozilla.org/en-US/MPL/2.0/)
 */

package io.udpn.commonsshutdownbootstarter.configuration;


import io.udpn.commonsshutdownbootstarter.support.ContextShutdown;
import io.udpn.commonsshutdownbootstarter.endpoint.RedShutdownEndpoint;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;

/**
 * shutdown configuration
 *
 * @author wb
 * @version 1.0.0
 * @Date: 2024/1/25
 * @history date, modifier,and description
 **/
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(ShutdownProperties.class)
public class ShutdownConfiguration {

  @ConditionalOnClass(Endpoint.class)
  protected class RedShutdownEndpointConfiguration {

    @Bean
    @ConditionalOnAvailableEndpoint
    public RedShutdownEndpoint redShutdownEndpoint(@Autowired(required = false) Registration registration,
        @Autowired(required = false) ServiceRegistry serviceRegistry) {
      return new RedShutdownEndpoint(serviceRegistry, registration);
    }

  }

  @ConditionalOnBean(ExecutorConfigurationSupport.class)
  protected class ThreadPoolConfiguration {

    @Autowired(required = false)
    private List<ExecutorConfigurationSupport> threadPoolList;

    @Bean
    public ThreadPoolShutdownConfiguration threadPoolShutdownConfiguration(ShutdownProperties shutdownProperties){
      ThreadPoolShutdownConfiguration threadPoolShutdownConfiguration = new ThreadPoolShutdownConfiguration(shutdownProperties);
      threadPoolShutdownConfiguration.setThreadPoolList(threadPoolList);
      return threadPoolShutdownConfiguration;
    }

  }


  @Bean
  public ContextShutdown contextShutdown(){
    return new ContextShutdown();
  }

}
