/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation.reporters;

import com.google.common.net.HostAndPort;
import io.tsdb.services.framework.common.instrumentation.reporters.AbstractHealthcheckReporter;
import io.tsdb.services.framework.common.instrumentation.reporters.HealthcheckResult;
import io.tsdb.services.framework.common.instrumentation.reporters.HealthcheckResultSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensuHealthcheckReporter
extends AbstractHealthcheckReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensuHealthcheckReporter.class);
    private String clientSocketHost = "localhost";
    private int clientSocketPort = 3030;

    public SensuHealthcheckReporter(int reportingInterval) {
        super(reportingInterval);
    }

    public SensuHealthcheckReporter(int reportingInterval, String clientSocketHost, int clientSocketPort) {
        super(reportingInterval);
        this.setClientSocketHost(clientSocketHost);
        this.setClientSocketPort(clientSocketPort);
    }

    public SensuHealthcheckReporter(int reportingInterval, HostAndPort sensuAddress) {
        super(reportingInterval);
        this.setClientSocketHost(sensuAddress.getHost());
        this.setClientSocketPort(sensuAddress.getPort());
    }

    @Override
    public void report(List<HealthcheckResult> results) {
        try {
            String serializedResults = HealthcheckResultSerializer.serializeList(results);
            Socket socket = new Socket(this.getClientSocketHost(), this.getClientSocketPort());
            PrintWriter output = new PrintWriter(socket.getOutputStream());
            output.print(serializedResults);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not send report to Sensu: " + e.getMessage());
        }
    }

    private String getClientSocketHost() {
        return this.clientSocketHost;
    }

    private void setClientSocketHost(String clientSocketHost) {
        this.clientSocketHost = clientSocketHost;
    }

    private int getClientSocketPort() {
        return this.clientSocketPort;
    }

    private void setClientSocketPort(int clientSocketPort) {
        this.clientSocketPort = clientSocketPort;
    }
}

