/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation.reporters;

import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.health.HealthCheck;
import io.tsdb.services.framework.common.instrumentation.Metrics;
import io.tsdb.services.framework.common.instrumentation.reporters.HealthcheckResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

abstract class AbstractHealthcheckReporter
implements Runnable {
    private static final InstrumentedScheduledExecutorService scheduler = new InstrumentedScheduledExecutorService(Executors.newScheduledThreadPool(2), Metrics.getMetricRegistry());

    abstract void report(List<HealthcheckResult> var1);

    AbstractHealthcheckReporter(int reportingInterval) {
        scheduler.scheduleAtFixedRate((Runnable)this, (long)reportingInterval, (long)reportingInterval, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        ArrayList<HealthcheckResult> checkResults = new ArrayList<HealthcheckResult>();
        for (Map.Entry entry : Metrics.getHealthCheckRegistry().runHealthChecks().entrySet()) {
            checkResults.add(new HealthcheckResult((String)entry.getKey(), (HealthCheck.Result)entry.getValue()));
        }
        this.report(checkResults);
    }
}

