/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.configuration;

import io.tsdb.services.framework.common.configuration.ConfigurationReader;
import io.tsdb.services.framework.common.configuration.ConfigurationSourceImpl;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertiesConfiguration
extends ConfigurationSourceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfiguration.class);
    private String filename = "resources/application.properties";

    PropertiesConfiguration(String filename, boolean reloadable) {
        this.filename = filename;
        if (reloadable) {
            this.readPropertiesFileReloadable(this.filename);
        } else {
            this.readPropertiesFile(this.filename);
        }
    }

    private void readPropertiesFile(String filename) {
        File propertiesFile = new File(filename);
        Parameters params = new Parameters();
        ClasspathLocationStrategy classpath = new ClasspathLocationStrategy();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(org.apache.commons.configuration2.PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)params.fileBased().setLocationStrategy((FileLocationStrategy)classpath)).setFile(propertiesFile)});
        try {
            this.configuration = (Configuration)builder.getConfiguration();
        }
        catch (ConfigurationException e) {
            LOGGER.error("Could not load configuration " + filename + ": " + e.getMessage());
            LOGGER.debug("Could not load configuration " + filename, (Throwable)e);
        }
    }

    private void readPropertiesFileReloadable(String propertiesFile) {
        try {
            LOGGER.debug("Trying to load: " + propertiesFile);
            Parameters params = new Parameters();
            ClasspathLocationStrategy classpath = new ClasspathLocationStrategy();
            FileSystemLocationStrategy filesystem = new FileSystemLocationStrategy();
            ProvidedURLLocationStrategy providedUrl = new ProvidedURLLocationStrategy();
            List<FileLocationStrategy> subs = Arrays.asList(providedUrl, filesystem, classpath);
            CombinedLocationStrategy strategy = new CombinedLocationStrategy(subs);
            ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(org.apache.commons.configuration2.PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)params.properties().setLocationStrategy((FileLocationStrategy)strategy)).setFileName(propertiesFile)});
            int reloadInterval = Integer.parseInt(ConfigurationReader.ENVIRONMENT_CONFIGURATION.getProperty("config.reload.interval.mins", "10"));
            LOGGER.debug("Loaded: " + propertiesFile);
            PeriodicReloadingTrigger trigger = new PeriodicReloadingTrigger(builder.getReloadingController(), null, (long)reloadInterval, TimeUnit.MINUTES);
            trigger.start();
            this.configuration = (Configuration)builder.getConfiguration();
        }
        catch (ConfigurationException e) {
            LOGGER.error("Could not load configuration " + this.filename + ": " + e.getMessage());
            LOGGER.debug("Could not load configuration " + this.filename, (Throwable)e);
        }
    }
}

