/*
 * Decompiled with CFR 0.152.
 */
package io.tsdb.services.framework.common.instrumentation.reporters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.tsdb.services.framework.common.instrumentation.reporters.HealthcheckResult;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class HealthcheckResultSerializer
implements JsonSerializer<HealthcheckResult>,
JsonDeserializer<HealthcheckResult> {
    private static final GsonBuilder builder = new GsonBuilder().serializeNulls().enableComplexMapKeySerialization();

    static Gson gsonMetricInfoFactory(boolean pretty) {
        if (pretty) {
            return builder.setPrettyPrinting().create();
        }
        return builder.create();
    }

    public JsonElement serialize(HealthcheckResult healthResult, Type type, JsonSerializationContext context) {
        JsonObject response = new JsonObject();
        response.add("name", (JsonElement)new JsonPrimitive(healthResult.getName()));
        response.add("output", (JsonElement)new JsonPrimitive(healthResult.getOutput()));
        response.add("status", (JsonElement)new JsonPrimitive((Number)healthResult.getStatus().getValue()));
        response.add("handlers", HealthcheckResultSerializer.handlersToJSON(healthResult.getHandlers()));
        response.add("tags", HealthcheckResultSerializer.tagsToJSON(healthResult.getTags()));
        return response;
    }

    private static JsonElement handlersToJSON(List<String> handlers) {
        Gson gson = HealthcheckResultSerializer.gsonMetricInfoFactory(false);
        return gson.toJsonTree(handlers);
    }

    private static JsonElement tagsToJSON(Map<String, String> tags) {
        Gson gson = HealthcheckResultSerializer.gsonMetricInfoFactory(false);
        return gson.toJsonTree(tags);
    }

    public HealthcheckResult deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return (HealthcheckResult)HealthcheckResultSerializer.gsonMetricInfoFactory(false).fromJson(json, HealthcheckResult.class);
    }

    static String serializeList(List<HealthcheckResult> healthResultList) {
        Gson gson = HealthcheckResultSerializer.gsonMetricInfoFactory(false);
        Type typeOfHealthResultList = new TypeToken<List<HealthcheckResult>>(){}.getType();
        return gson.toJson(healthResultList, typeOfHealthResultList);
    }

    static {
        builder.registerTypeAdapter(HealthcheckResult.class, (Object)new HealthcheckResultSerializer());
    }
}

